/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.session.Session;
import org.rzo.netty.ahessian.session.SessionFactory;

@ChannelHandler.Sharable
public class ServerSessionFilter
extends ChannelInboundHandlerAdapter {
    private boolean _hasSession = false;
    private String _sessionId = "";
    private SessionFactory _factory = new SessionFactory();
    private ChannelPipelineFactory _mixinFactory;
    private static Map<String, ChannelPipelineFactory.HandlerList> _sessionPipelines = Collections.synchronizedMap(new HashMap());
    private long _sessionTimeout = -1L;
    private Timer _timer = null;
    private volatile Channel _channel = null;
    private volatile boolean _valid = true;
    public static final AttributeKey<Session> SESSION = AttributeKey.valueOf((String)"SESSION");

    public ServerSessionFilter(ChannelPipelineFactory mixinFactory, Timer timer, long sessionTimeout) {
        this._mixinFactory = mixinFactory;
        this._timer = timer;
        this._sessionTimeout = sessionTimeout;
    }

    public ServerSessionFilter(ChannelPipelineFactory mixinFactory) {
        this(mixinFactory, null, -1L);
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        if (this._hasSession) {
            Session session = (Session)ctx.channel().attr(SESSION).get();
            session.onMessage();
            ctx.fireChannelRead(e);
        } else {
            ByteBuf b = (ByteBuf)e;
            this._sessionId = this._sessionId + b.toString(Charset.forName("UTF-8"));
            b.release(b.refCnt());
            if (this._sessionId.equals("?")) {
                this.newSession(ctx);
            } else {
                this.checkSession(ctx);
            }
        }
    }

    private void checkSession(ChannelHandlerContext ctx) {
        if (this._sessionId.length() == this._factory.getSessionIdLength() * 2) {
            Session session = this._factory.getSession(this._sessionId);
            if (session == null) {
                this.newSession(ctx);
            } else {
                this.confirmSession(ctx);
            }
        }
    }

    private void newSession(ChannelHandlerContext ctx) {
        Session session = this._factory.createSession(null);
        Constants.ahessianLogger.info(ctx.channel() + " new session #" + session.getId());
        ChannelPipelineFactory.HandlerList pipeline = null;
        try {
            pipeline = this._mixinFactory.getPipeline();
            _sessionPipelines.put(session.getId(), pipeline);
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
        this.handleSession(ctx, session, pipeline);
    }

    private void confirmSession(ChannelHandlerContext ctx) {
        Session session = this._factory.getSession(this._sessionId);
        Constants.ahessianLogger.info(ctx.channel() + " reuse session #" + session.getId());
        ChannelPipelineFactory.HandlerList pipeline = _sessionPipelines.get(this._sessionId);
        this.handleSession(ctx, session, pipeline);
    }

    private void handleSession(ChannelHandlerContext ctx, Session session, ChannelPipelineFactory.HandlerList pipeline) {
        this._hasSession = true;
        session.setClosed(false);
        Timeout timeOut = session.removeTimeout();
        if (timeOut != null) {
            timeOut.cancel();
        }
        if (pipeline.hasChannel()) {
            Constants.ahessianLogger.warn(ctx.channel() + " session already attached -> close connection");
            pipeline.close();
        }
        pipeline.mixin(ctx);
        ctx.channel().attr(SESSION).set((Object)session);
        this._channel = ctx.channel();
        ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])session.getId().getBytes())).awaitUninterruptibly();
        ctx.fireChannelActive();
    }

    public static Session getSession(ChannelHandlerContext ctx) {
        return (Session)ctx.channel().attr(SESSION).get();
    }

    public void channelInactive(final ChannelHandlerContext ctx) throws Exception {
        this._hasSession = false;
        ((Session)ctx.channel().attr(SESSION).get()).close();
        final String sessionId = ((Session)ctx.channel().attr(SESSION).get()).getId();
        Constants.ahessianLogger.info("Session disconnected: " + sessionId);
        this._sessionId = "";
        this._channel = null;
        if (this._sessionTimeout > 0L) {
            Timeout timeOut = this._timer.newTimeout(new TimerTask(){

                public void run(Timeout arg0) throws Exception {
                    ((Session)ctx.channel().attr(SESSION).get()).invalidate();
                    ServerSessionFilter.this._factory.removeSession(sessionId);
                    _sessionPipelines.remove(sessionId);
                    ServerSessionFilter.this._valid = false;
                    Constants.ahessianLogger.warn(ctx.channel() + " session timed out: " + sessionId);
                }
            }, this._sessionTimeout, TimeUnit.MILLISECONDS);
            ((Session)ctx.channel().attr(SESSION).get()).setTimeOut(timeOut);
        }
        ctx.fireChannelInactive();
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this._sessionTimeout = sessionTimeout;
    }

    public boolean isValid() {
        return this._valid;
    }

    public Channel getChannel() {
        return this._channel;
    }

    public static ServerSessionFilter getServerSessionFilter(ChannelHandlerContext ctx) {
        return (ServerSessionFilter)ctx.pipeline().context(ServerSessionFilter.class).handler();
    }
}

