/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.lifecycle.Internal;
import ghidra.pcode.struct.BlockStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;

abstract class AbstractStmt
implements StructuredSleigh.Stmt {
    protected final StructuredSleigh ctx;
    protected AbstractStmt parent;

    protected AbstractStmt(StructuredSleigh ctx) {
        this.ctx = ctx;
        BlockStmt parent = ctx.stack.peek();
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public StructuredSleigh getContext() {
        return this.ctx;
    }

    @Internal
    protected AbstractStmt reparent(AbstractStmt newParent) {
        assert (this.parent instanceof BlockStmt);
        BlockStmt parent = (BlockStmt)this.parent;
        parent.children.remove(this);
        this.parent = newParent;
        return this;
    }

    @Internal
    protected <T extends StructuredSleigh.Stmt> T nearest(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return (T)((StructuredSleigh.Stmt)cls.cast(this));
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.nearest(cls);
    }

    protected abstract StringTree generate(StructuredSleigh.Label var1, StructuredSleigh.Label var2);

    protected boolean isSingleGoto() {
        return false;
    }

    protected StructuredSleigh.Label getNext() {
        return this.ctx.FALL;
    }
}

