/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.modal;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.modal.Modal;
import org.jungrapht.visualization.control.modal.ModeComboBox;
import org.jungrapht.visualization.control.modal.ModeControl;
import org.jungrapht.visualization.control.modal.ModeMenu;

public class ModeControls {
    public static JComboBox getStandardModeComboBox() {
        return ModeComboBox.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING).build().buildUI();
    }

    public static JComboBox getStandardModeComboBox(Modal.Mode mode, ModalGraphMouse ... graphMice) {
        ModeComboBox comboBox = ModeComboBox.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING).modals(graphMice).mode(mode).build().buildUI();
        return comboBox;
    }

    public static JComboBox getStandardModeComboBox(ModalGraphMouse ... graphMice) {
        return ModeControls.getStandardModeComboBox(Modal.Mode.TRANSFORMING, graphMice);
    }

    public static JComboBox getEditingModeComboBox(ModalGraphMouse ... graphMice) {
        ModeComboBox comboBox = ModeComboBox.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING, Modal.Mode.EDITING, Modal.Mode.ANNOTATING).mode(Modal.Mode.EDITING).modals(graphMice).build().buildUI();
        return comboBox;
    }

    public static JComboBox getEditingDefaultModeComboBox(ModalGraphMouse ... graphMice) {
        ModeComboBox comboBox = ModeComboBox.builder().modes(Modal.Mode.DEFAULT, Modal.Mode.EDITING, Modal.Mode.ANNOTATING).mode(Modal.Mode.EDITING).modals(graphMice).build().buildUI();
        return comboBox;
    }

    public static JComboBox getAnnotationModeComboBox(ModalGraphMouse ... graphMice) {
        ModeComboBox comboBox = ModeComboBox.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING, Modal.Mode.ANNOTATING).mode(Modal.Mode.EDITING).modals(graphMice).build().buildUI();
        return comboBox;
    }

    public static JMenu getStandardModeMenu() {
        ModeMenu modeMenu = ModeMenu.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING).buttonSupplier(JRadioButtonMenuItem::new).build();
        return modeMenu.buildUI();
    }

    public static JMenu getStandardModeMenu(Modal.Mode mode, ModalGraphMouse ... graphMice) {
        ModeMenu modeMenu = ModeMenu.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING).modals(graphMice).mode(mode).buttonSupplier(JRadioButtonMenuItem::new).build();
        return modeMenu.buildUI();
    }

    public static JMenu getStandardModeMenu(ModalGraphMouse ... graphMice) {
        return ModeControls.getStandardModeMenu(Modal.Mode.TRANSFORMING, graphMice);
    }

    public static JMenu getEditingModeMenu(ModalGraphMouse ... graphMice) {
        ModeMenu modeMenu = ModeMenu.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING, Modal.Mode.EDITING).mode(Modal.Mode.EDITING).modals(graphMice).buttonSupplier(JRadioButtonMenuItem::new).build();
        return modeMenu.buildUI();
    }

    public static JMenu getAnnotatingModeMenu(ModalGraphMouse ... graphMice) {
        ModeMenu modeMenu = ModeMenu.builder().modes(Modal.Mode.TRANSFORMING, Modal.Mode.PICKING, Modal.Mode.ANNOTATING, Modal.Mode.EDITING).mode(Modal.Mode.ANNOTATING).modals(graphMice).buttonSupplier(JRadioButtonMenuItem::new).build();
        return modeMenu.buildUI();
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModeControl modeControl;

        public ModeKeyAdapter(ModeControl modeControl) {
            this.modeControl = modeControl;
        }

        public ModeKeyAdapter(char t, char p, ModeControl modeControl) {
            this.t = t;
            this.p = p;
            this.modeControl = modeControl;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.modeControl.setMode(Modal.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.modeControl.setMode(Modal.Mode.PICKING);
            }
        }
    }
}

