/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store;

import db.buffers.BufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystemListener;
import ghidra.framework.store.FolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public interface FileSystem {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = Character.toString('/');

    public String getUserName();

    public boolean isVersioned();

    public boolean isOnline();

    public boolean isReadOnly() throws IOException;

    public int getItemCount() throws IOException, UnsupportedOperationException;

    public String[] getItemNames(String var1) throws IOException;

    public FolderItem[] getItems(String var1) throws IOException;

    public FolderItem getItem(String var1, String var2) throws IOException;

    public FolderItem getItem(String var1) throws IOException, UnsupportedOperationException;

    public String[] getFolderNames(String var1) throws IOException;

    public void createFolder(String var1, String var2) throws InvalidNameException, IOException;

    public DatabaseItem createDatabase(String var1, String var2, String var3, BufferFile var4, String var5, String var6, boolean var7, TaskMonitor var8, String var9) throws InvalidNameException, IOException, CancelledException;

    public ManagedBufferFile createDatabase(String var1, String var2, String var3, String var4, int var5, String var6, String var7) throws InvalidNameException, IOException;

    public DataFileItem createDataFile(String var1, String var2, InputStream var3, String var4, String var5, TaskMonitor var6) throws InvalidNameException, IOException, CancelledException;

    public FolderItem createFile(String var1, String var2, File var3, TaskMonitor var4, String var5) throws InvalidNameException, IOException, CancelledException;

    public void deleteFolder(String var1) throws IOException;

    public void moveFolder(String var1, String var2, String var3) throws InvalidNameException, IOException;

    public void renameFolder(String var1, String var2, String var3) throws InvalidNameException, IOException;

    public void moveItem(String var1, String var2, String var3, String var4) throws IOException, InvalidNameException;

    public void addFileSystemListener(FileSystemListener var1);

    public void removeFileSystemListener(FileSystemListener var1);

    public boolean folderExists(String var1) throws IOException;

    public boolean fileExists(String var1, String var2) throws IOException;

    public boolean isShared();

    public void dispose();
}

