/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PackedSwitchPayload
implements StructConverter {
    public static final short MAGIC = 256;
    private short ident;
    private short size;
    private int firstKey;
    private int[] targets;

    public PackedSwitchPayload(BinaryReader reader) throws IOException {
        this.ident = reader.readNextShort();
        this.size = reader.readNextShort();
        this.firstKey = reader.readNextInt();
        this.targets = reader.readNextIntArray(this.size & 0xFFFF);
    }

    public short getIdent() {
        return this.ident;
    }

    public short getSize() {
        return this.size;
    }

    public int getFirstKey() {
        return this.firstKey;
    }

    public int[] getTargets() {
        return this.targets;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("packed_switch_payload_" + this.size, 0);
        structure.add(WORD, "ident", null);
        structure.add(WORD, "size", null);
        structure.add(DWORD, "first_key", null);
        structure.add((DataType)new ArrayDataType(DWORD, this.size & 0xFFFF, DWORD.getLength()), "targets", null);
        structure.setCategoryPath(new CategoryPath("/dex/packed_switch_payload"));
        return structure;
    }
}

