/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PrototypesIDItem
implements StructConverter {
    private int shortyIndex;
    private int returnTypeIndex;
    private int parametersOffset;
    private TypeList _parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrototypesIDItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        this.shortyIndex = reader.readNextInt();
        this.returnTypeIndex = reader.readNextInt();
        this.parametersOffset = reader.readNextInt();
        if (this.parametersOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                int adjustedParametersOffset = DexUtil.adjustOffset(this.parametersOffset, dexHeader);
                if (reader.isValidIndex(adjustedParametersOffset)) {
                    reader.setPointerIndex(adjustedParametersOffset);
                    this._parameters = new TypeList(reader);
                }
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getShortyIndex() {
        return this.shortyIndex;
    }

    public int getReturnTypeIndex() {
        return this.returnTypeIndex;
    }

    public int getParametersOffset() {
        return this.parametersOffset;
    }

    public TypeList getParameters() {
        return this._parameters;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(PrototypesIDItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

