/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFileUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class OatDexFile_OreoM2
extends OatDexFile {
    private int dex_file_location_;
    private String canonical_dex_file_location_;
    private int dex_file_location_checksum_;
    private int dex_file_pointer_;
    private int lookup_table_data_;
    private int method_bss_mapping_;
    private int oat_class_offsets_pointer_;
    private int dex_cache_arrays_;
    private long _offset;
    private DexHeader dexHeader;

    OatDexFile_OreoM2(BinaryReader reader, OatBundle bundle) throws IOException {
        this._offset = reader.getPointerIndex();
        this.dex_file_location_ = reader.readNextInt();
        this.canonical_dex_file_location_ = reader.readNextAsciiString(this.dex_file_location_);
        this.dex_file_location_checksum_ = reader.readNextInt();
        this.dex_file_pointer_ = reader.readNextInt();
        this.lookup_table_data_ = reader.readNextInt();
        this.method_bss_mapping_ = reader.readNextInt();
        this.oat_class_offsets_pointer_ = reader.readNextInt();
        this.dex_cache_arrays_ = reader.readNextInt();
        this.dexHeader = bundle.getDexHeaderByChecksum(this.dex_file_location_checksum_);
    }

    @Override
    public int getDexFileChecksum() {
        return this.dex_file_location_checksum_;
    }

    @Override
    public DexHeader getDexHeader() {
        return this.dexHeader;
    }

    @Override
    public int getDexFileOffset() {
        return this.dex_file_pointer_;
    }

    @Override
    public String getDexFileLocation() {
        return this.canonical_dex_file_location_;
    }

    @Override
    public boolean isDexHeaderExternal() {
        return true;
    }

    public int getLookupTableData() {
        return this.lookup_table_data_;
    }

    public int getMethodBssMapping() {
        return this.method_bss_mapping_;
    }

    public int getOatClassOffsetsPointer() {
        return this.oat_class_offsets_pointer_;
    }

    public int getDexCacheArrays() {
        return this.dex_cache_arrays_;
    }

    @Override
    public void markup(OatHeader oatHeader, Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Address address = oatDataSymbol.getAddress();
        Address dataAddress = address.add(this._offset);
        program.getListing().clearCodeUnits(dataAddress, dataAddress, false, monitor);
        Data data = program.getListing().createData(dataAddress, this.toDataType());
        for (int i = 0; i < data.getNumComponents(); ++i) {
            monitor.checkCancelled();
            Data componentI = data.getComponent(i);
            if (!componentI.getFieldName().startsWith("lookup_table_data_") && !componentI.getFieldName().startsWith("oat_class_offsets_pointer_") && !componentI.getFieldName().startsWith("lookup_table_data_") && !componentI.getFieldName().startsWith("method_bss_mapping_") && !componentI.getFieldName().startsWith("oat_class_offsets_pointer_") && !componentI.getFieldName().startsWith("dex_cache_arrays_")) continue;
            Scalar scalar = componentI.getScalar(0);
            Address destinationAddress = address.add(scalar.getUnsignedValue());
            program.getReferenceManager().addMemoryReference(componentI.getMinAddress(), destinationAddress, RefType.DATA, SourceType.ANALYSIS, 0);
            program.getSymbolTable().createLabel(destinationAddress, componentI.getFieldName(), SourceType.ANALYSIS);
            if (!componentI.getFieldName().startsWith("lookup_table_data_")) continue;
            OatDexFileUtilities.markupLookupTableData(this.getClass(), destinationAddress, this.dexHeader, oatHeader, program, monitor, log);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatDexFile_OreoM2.class.getSimpleName() + "_" + this.dex_file_location_, 0);
        structure.add(DWORD, "dex_file_location_", null);
        structure.add(STRING, this.dex_file_location_, "canonical_dex_file_location_", null);
        structure.add(DWORD, "dex_file_location_checksum_", null);
        structure.add(DWORD, "dex_file_pointer_", null);
        structure.add(DWORD, "lookup_table_data_", null);
        structure.add(DWORD, "method_bss_mapping_", null);
        structure.add(DWORD, "oat_class_offsets_pointer_", null);
        structure.add(DWORD, "dex_cache_arrays_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

