/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.versions;

import ghidra.file.formats.android.versions.AndroidVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AndroidVersionManager {
    public static final String PLATFORM_BUILD_VERSION_NAME = "platformBuildVersionName";
    public static final String PLATFORM_BUILD_VERSION_CODE = "platformBuildVersionCode";

    public static List<AndroidVersion> getByAPI(int api) {
        ArrayList<AndroidVersion> list = new ArrayList<AndroidVersion>();
        for (AndroidVersion androidVersion : AndroidVersion.values()) {
            if (androidVersion.getApiVersion() != api) continue;
            list.add(androidVersion);
        }
        return list;
    }

    public static AndroidVersion getByNumber(String number) {
        for (AndroidVersion androidVersion : AndroidVersion.values()) {
            if (!androidVersion.getVersionNumber().equals(number)) continue;
            return androidVersion;
        }
        return AndroidVersion.UNKNOWN;
    }

    public static List<AndroidVersion> getByLetter(char letter) {
        ArrayList<AndroidVersion> list = new ArrayList<AndroidVersion>();
        for (AndroidVersion androidVersion : AndroidVersion.values()) {
            if (androidVersion.getVersionLetter() != letter) continue;
            list.add(androidVersion);
        }
        return list;
    }

    public static List<AndroidVersion> getByLetter(String letter) {
        if (letter == null || letter.length() == 0) {
            return Collections.emptyList();
        }
        return AndroidVersionManager.getByLetter(letter.charAt(0));
    }

    public static List<AndroidVersion> getByName(String name) {
        ArrayList<AndroidVersion> list = new ArrayList<AndroidVersion>();
        for (AndroidVersion androidVersion : AndroidVersion.values()) {
            if (!androidVersion.getVersionName().equals(name)) continue;
            list.add(androidVersion);
        }
        return list;
    }

    public static AndroidVersion getByPlatformBuildVersion(String code, String name) {
        for (AndroidVersion version : AndroidVersion.values()) {
            if (version.getApiVersion() == AndroidVersionManager.toInteger(code)) {
                return version;
            }
            if (version.getVersionName().equals(name)) {
                return version;
            }
            if (version.getVersionNumber().equals(name)) {
                return version;
            }
            if (!String.valueOf(version.getVersionLetter()).equals(name)) continue;
            return version;
        }
        return AndroidVersion.UNKNOWN;
    }

    private static int toInteger(String platformBuildVersionCode) {
        try {
            return Integer.parseInt(platformBuildVersionCode);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

