/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cramfs.CramFsInode;
import ghidra.file.formats.cramfs.CramFsSuper;
import ghidra.file.formats.cramfs.LazyCramFsInputStream;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="cramfs", description="CRAMFS", factory=GFileSystemBaseFactory.class)
public class CramFsFileSystem
extends GFileSystemBase {
    private boolean isLittleEndian;
    private CramFsSuper cramFsSuper;
    private Map<GFile, CramFsInode> fileToInodeMap = new HashMap<GFile, CramFsInode>();
    private List<GFile> rootListing = new ArrayList<GFile>();
    private Map<GFile, List<GFile>> directoryToChildMap = new HashMap<GFile, List<GFile>>();

    public CramFsFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, 4L);
        DataConverter[] dataConverter = new DataConverter[]{new LittleEndianDataConverter(), new BigEndianDataConverter()};
        for (int i = 0; i < dataConverter.length; ++i) {
            if (dataConverter[i].getInt(bytes) != 684539205) continue;
            this.isLittleEndian = !dataConverter[i].isBigEndian();
            return true;
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, this.isLittleEndian);
        this.cramFsSuper = new CramFsSuper(reader);
        if (this.cramFsSuper.isExtensionsBlockPointerFlagEnabled()) {
            throw new IOException("Extended Block Pointer flag is set, currently unsupported");
        }
        List<CramFsInode> childList = this.cramFsSuper.getChildList();
        HashMap<Long, CramFsInode> subDirectoryMap = new HashMap<Long, CramFsInode>();
        GFileImpl parent = this.root;
        for (CramFsInode cramFsInode : childList) {
            monitor.checkCancelled();
            if (cramFsInode.isDirectory()) {
                subDirectoryMap.put(Long.valueOf(cramFsInode.getOffsetAdjusted()), cramFsInode);
            }
            if (subDirectoryMap.containsKey(cramFsInode.getAddress())) break;
            GFileImpl iNodeFile = GFileImpl.fromPathString((GFileSystem)this, (GFile)parent, (String)cramFsInode.getName(), null, (boolean)cramFsInode.isDirectory(), (long)cramFsInode.getSize());
            this.fileToInodeMap.put((GFile)iNodeFile, cramFsInode);
            this.rootListing.add((GFile)iNodeFile);
        }
    }

    private CramFsInode getChildInodeByName(String targetName) {
        CramFsInode target = null;
        List<CramFsInode> childList = this.cramFsSuper.getChildList();
        for (CramFsInode cramFsInode : childList) {
            if (!cramFsInode.getName().contentEquals(targetName)) continue;
            target = cramFsInode;
            break;
        }
        return target;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == this.root || directory == null) {
            return this.rootListing;
        }
        if (this.directoryToChildMap.containsKey(directory)) {
            return this.directoryToChildMap.get(directory);
        }
        CramFsInode parentInode = this.getChildInodeByName(directory.getName());
        int directoryLength = parentInode.getSize();
        List<GFile> directoryListing = this.populateChildList(directory, parentInode, directoryLength);
        this.directoryToChildMap.put(directory, directoryListing);
        return directoryListing;
    }

    private List<GFile> populateChildList(GFile directory, CramFsInode parentInode, int directoryLength) {
        int startIndex;
        CramFsInode entryInode;
        List<CramFsInode> childList = this.cramFsSuper.getChildList();
        ArrayList<GFile> directoryListing = new ArrayList<GFile>();
        for (int i = startIndex = this.computeStartIndex(childList, parentInode); i < childList.size() && directoryLength > 0; directoryLength -= 12 + entryInode.getNamelen() * 4, ++i) {
            entryInode = childList.get(i);
            GFileImpl iNodeFile = GFileImpl.fromPathString((GFileSystem)this, (GFile)directory, (String)entryInode.getName(), null, (boolean)entryInode.isDirectory(), (long)entryInode.getSize());
            directoryListing.add((GFile)iNodeFile);
            this.fileToInodeMap.put((GFile)iNodeFile, entryInode);
        }
        return directoryListing;
    }

    private int computeStartIndex(List<CramFsInode> childList, CramFsInode parentInode) {
        int startIndex = 0;
        for (int i = 0; i < childList.size(); ++i) {
            if (childList.get(i).getAddress() != (long)parentInode.getOffsetAdjusted()) continue;
            startIndex = i;
            break;
        }
        return startIndex;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        CramFsInode childInode = this.fileToInodeMap.get(file);
        if (childInode.getSize() >= 0xFFFFFF) {
            throw new IOException("File is larger than 16MB and was clipped, cannot open.");
        }
        ByteProvider fileBP = this.fsService.getDerivedByteProvider(this.provider.getFSRL(), file.getFSRL(), file.getPath(), (long)childInode.getSize(), () -> new LazyCramFsInputStream(this.provider, childInode, this.cramFsSuper.isLittleEndian()), monitor);
        return fileBP;
    }
}

