/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FdtProperty
implements StructConverter {
    private int tag;
    private int length;
    private int nameOffset;
    private byte[] data;

    public FdtProperty(BinaryReader reader) throws IOException {
        this.tag = reader.readNextInt();
        this.length = reader.readNextInt();
        this.nameOffset = reader.readNextInt();
        this.length = (int)NumericUtilities.getUnsignedAlignedValue((long)this.length, (long)4L);
        this.data = this.length == 0 ? new byte[]{} : reader.readNextByteArray(this.length);
    }

    public int getTag() {
        return this.tag;
    }

    public int getLength() {
        return this.length;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataAsString() {
        if (this.length > 0) {
            if (StringUtilities.isAsciiChar((int)this.data[0])) {
                return new String(this.data).trim();
            }
            return NumericUtilities.convertBytesToString((byte[])this.data);
        }
        return "<empty>";
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(this.getDataTypeName(), 0);
        structure.add(DWORD, "tag", null);
        structure.add(DWORD, "len", null);
        structure.add(DWORD, "nameoff", null);
        if (this.length > 0) {
            if (StringUtilities.isAsciiChar((int)this.data[0])) {
                structure.add(STRING, this.length, "data", null);
            } else {
                ArrayDataType array = new ArrayDataType(BYTE, this.length, BYTE.getLength());
                structure.add((DataType)array, this.length, "data", null);
            }
        }
        return structure;
    }

    private String getDataTypeName() {
        String name = "fdt_property_" + this.length;
        if (this.length > 0 && StringUtilities.isAsciiChar((int)this.data[0])) {
            return name + "_s";
        }
        return name;
    }
}

