/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.timer.Watchdog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import utilities.util.FileUtilities;

class DmgServerProcessManager
implements Closeable {
    public static final String DMG_MODULE_NAME = "DMG";
    private static final int MIN_DMG_SERVER_MEMORY_MB = 100;
    private File file;
    private Process process = null;
    private Thread cmdThread;
    private SynchronousQueue<Cmd> cmdQueue = new SynchronousQueue();
    private int dmgServerMemoryMB;
    private int cmdCount;
    private int dmgServerMaxCmdPerSession = 25000;
    private int dmgCmdTimeoutMS = 20000;
    private Watchdog watchdog = new Watchdog((long)this.dmgCmdTimeoutMS, this::timeoutMethod);
    private String logPrefix;

    DmgServerProcessManager(File file, String logPrefix) {
        this.file = file;
        this.logPrefix = logPrefix;
        this.dmgServerMemoryMB = this.readDMGServerMemoryConfigValue(1024);
        this.cmdThread = new Thread(this::processManagerLoop, "DMG client/server command loop");
        this.cmdThread.start();
    }

    public void setDMGServerMemoryMB(int mb) {
        this.dmgServerMemoryMB = mb;
    }

    @Override
    public void close() throws IOException {
        Msg.info((Object)this, (Object)"Shutting down DMG server");
        this.sendCmd(null, 0);
    }

    public void interruptCmd() {
        this.timeoutMethod();
    }

    private void timeoutMethod() {
        Process localProcess = this.process;
        if (localProcess != null && localProcess.isAlive()) {
            localProcess.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processManagerLoop() {
        block22: while (true) {
            if (this.cmdCount == 0) {
                Msg.debug((Object)this, (Object)"Starting new DMG server process");
            } else {
                Msg.debug((Object)this, (Object)("Re-starting DMG server process, cmd count: " + this.cmdCount));
            }
            this.process = this.createProcess();
            if (this.process == null) {
                Msg.error((Object)this, (Object)"Failed to create new DMG server process, exiting cmd loop");
                return;
            }
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            PrintWriter outputWriter = new PrintWriter(this.process.getOutputStream());
            this.startReaderThread(new BufferedReader(new InputStreamReader(this.process.getErrorStream())));
            Cmd startupCmd = new Cmd(this, "open " + this.file.getAbsolutePath(), 0);
            try {
                while (true) {
                    if (++this.cmdCount % this.dmgServerMaxCmdPerSession == 0) continue block22;
                    Cmd cmd = startupCmd != null ? startupCmd : this.cmdQueue.take();
                    startupCmd = null;
                    Cmd cmd2 = cmd;
                    synchronized (cmd2) {
                        try {
                            if (cmd.cmdStr != null) {
                                this.watchdog.arm();
                                outputWriter.println(cmd.cmdStr);
                                outputWriter.flush();
                                int expectedResponseCount = cmd.expectedResponseCount;
                                if (expectedResponseCount == Integer.MIN_VALUE) {
                                    expectedResponseCount = this.readInt(inputReader);
                                } else if (expectedResponseCount < 0) {
                                    int nestedResponseCount = -expectedResponseCount;
                                    expectedResponseCount = this.readInt(inputReader) * nestedResponseCount;
                                }
                                cmd.results = new ArrayList<String>(expectedResponseCount);
                                for (int i = 0; i < expectedResponseCount; ++i) {
                                    String s = inputReader.readLine();
                                    if (s == null) {
                                        throw new IOException("EOF while reading results from DMG Server");
                                    }
                                    cmd.results.add(s);
                                }
                            }
                        }
                        catch (IOException ioe) {
                            cmd.error = ioe;
                            continue block22;
                        }
                        finally {
                            this.watchdog.disarm();
                            cmd.notifyAll();
                        }
                    }
                    if (cmd.cmdStr != null) continue;
                    return;
                }
            }
            catch (InterruptedException ie) {
                Msg.error((Object)this, (Object)"IntrError", (Throwable)ie);
                return;
            }
            finally {
                Msg.info((Object)this, (Object)"DMG server process destroyed");
                this.process.destroy();
                try {
                    int exitCode = this.process.waitFor();
                    Msg.debug((Object)this, (Object)("DMG Server process exited with: " + exitCode));
                }
                catch (InterruptedException interruptedException) {}
                this.process = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sendCmd(String cmdStr, int expectedResults) throws IOException {
        Cmd cmd;
        Cmd cmd2 = cmd = new Cmd(this, cmdStr, expectedResults);
        synchronized (cmd2) {
            try {
                this.cmdQueue.put(cmd);
                cmd.wait(this.dmgCmdTimeoutMS * 2);
                if (cmd.error != null) {
                    throw cmd.error;
                }
                return cmd.results;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return cmd.results;
    }

    private Process createProcess() {
        String classPath = this.buildClasspath();
        String[] envp = this.buildEnvironmentVariables();
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        try {
            Process p = Runtime.getRuntime().exec(new String[]{java, "-classpath", classPath, "-Xmx" + this.dmgServerMemoryMB + "m", "mobiledevices.dmg.server.DmgServer"}, envp, null);
            return p;
        }
        catch (IOException e) {
            Msg.info((Object)this, (Object)"Error when creating DMG sever process: ", (Throwable)e);
            return null;
        }
    }

    private String buildClasspath() {
        ResourceFile[] standaloneLibs;
        StringBuilder builder = new StringBuilder();
        ResourceFile dmgModule = Application.getModuleRootDir((String)DMG_MODULE_NAME);
        ResourceFile standaloneLibDir = new ResourceFile(dmgModule, "data/lib");
        for (ResourceFile standaloneLib : standaloneLibs = standaloneLibDir.listFiles()) {
            if (!standaloneLib.getName().endsWith(".jar")) continue;
            File standaloneLibFile = standaloneLib.getFile(true);
            builder.append(standaloneLibFile.getAbsolutePath());
            builder.append(File.pathSeparator);
        }
        if (SystemUtilities.isInDevelopmentMode()) {
            ResourceFile binDirectory = new ResourceFile(dmgModule, "bin/dmg");
            builder.append(binDirectory.getAbsolutePath());
            builder.append(File.pathSeparator);
        }
        return builder.toString();
    }

    private int readDMGServerMemoryConfigValue(int defaultValue) {
        ResourceFile dmgModule = Application.getModuleRootDir((String)DMG_MODULE_NAME);
        ResourceFile serverMemoryCfgFile = new ResourceFile(dmgModule, "data/server_memory.cfg");
        try {
            List lines = FileUtilities.getLines((ResourceFile)serverMemoryCfgFile);
            int result = lines.size() > 0 ? Math.max(Integer.parseInt((String)lines.get(0)), 100) : defaultValue;
            return result;
        }
        catch (IOException | NumberFormatException exception) {
            return defaultValue;
        }
    }

    private String[] buildEnvironmentVariables() {
        String pathValue = this.getLibraryPathVariable("PATH", "");
        String ldLibraryPathValue = this.getLibraryPathVariable("LD_LIBRARY_PATH", "");
        ArrayList<Object> argList = new ArrayList<Object>();
        Map<String, String> env = System.getenv();
        Set<Map.Entry<String, String>> entrySet = env.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getKey().equalsIgnoreCase("PATH")) {
                pathValue = this.getLibraryPathVariable(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("LD_LIBRARY_PATH")) {
                ldLibraryPathValue = this.getLibraryPathVariable(entry.getKey(), entry.getValue());
                continue;
            }
            argList.add(entry.getKey() + "=" + entry.getValue());
        }
        argList.add(pathValue);
        argList.add(ldLibraryPathValue);
        return argList.toArray(new String[argList.size()]);
    }

    private String getLibraryPathVariable(String pathKey, String pathValue) {
        HashSet<String> libraryPaths = new HashSet<String>();
        this.addOSPaths(libraryPaths);
        StringBuffer buffy = new StringBuffer();
        buffy.append(pathKey + "=");
        for (String path : libraryPaths) {
            buffy.append(path).append(File.pathSeparator);
        }
        buffy.append(pathValue);
        return buffy.toString();
    }

    private void addOSPaths(Set<String> pathSet) {
        String osFilePath = "data/os/" + Platform.CURRENT_PLATFORM.getDirectoryName();
        ResourceFile module = Application.getModuleRootDir((String)DMG_MODULE_NAME);
        ResourceFile standaloneOSDir = new ResourceFile(module, osFilePath);
        ResourceFile[] standaloneResourceFiles = standaloneOSDir.listFiles();
        if (standaloneResourceFiles == null) {
            return;
        }
        for (ResourceFile resourceFile : standaloneResourceFiles) {
            File standaloneFile = resourceFile.getFile(true);
            pathSet.add(standaloneFile.getParentFile().getAbsolutePath());
        }
    }

    int readInt(BufferedReader inputReader) throws IOException {
        String s = inputReader.readLine();
        if (s == null) {
            throw new IOException("EOF while reading results from DMG Server");
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Bad data while reading result from DMG Server, expected integer: " + s, nfe);
        }
    }

    private void startReaderThread(BufferedReader reader) {
        new Thread(() -> {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Msg.info((Object)this, (Object)(this.logPrefix + ": " + line));
                }
            }
            catch (IOException line) {
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Exception while reading output from DMG process", (Throwable)e);
            }
        }, "DMG Server StdErr Reader Thread").start();
    }

    private class Cmd {
        static final int UNKNOWN_RESPONSE_COUNT = Integer.MIN_VALUE;
        String cmdStr;
        int expectedResponseCount;
        List<String> results;
        IOException error;

        Cmd(DmgServerProcessManager dmgServerProcessManager, String cmdStr, int expectedResponseCount) {
            this.cmdStr = cmdStr;
            this.expectedResponseCount = expectedResponseCount;
        }
    }
}

