/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.DyldCacheFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldCacheFileSystemFactory
implements GFileSystemFactoryByteProvider<DyldCacheFileSystem>,
GFileSystemProbeByteProvider {
    public DyldCacheFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        DyldCacheFileSystem fs = new DyldCacheFileSystem(targetFSRL, byteProvider);
        try {
            fs.mount(monitor);
            return fs;
        }
        catch (MachException e) {
            throw new IOException(e);
        }
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (!DyldCacheUtils.isDyldCache((ByteProvider)byteProvider)) {
            return false;
        }
        try {
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(byteProvider, true));
            return !header.isSubcache();
        }
        catch (IOException e) {
            return false;
        }
    }
}

