/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassFileInfo;
import ghidra.util.classfinder.ClassLocation;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import utility.application.ApplicationLayout;

class ClassJar
implements ClassLocation {
    private static final Pattern ANY_MODULE_LIB_JAR_FILE_PATTERN = Pattern.compile(".*/(.*)/(?:lib|build/libs)/(.+).jar");
    private static final String PATCH_DIR_PATH_FORWARD_SLASHED = ClassJar.getPatchDirPath();
    private static final Set<String> USER_PLUGIN_PATHS = ClassJar.loadUserPluginPaths();
    private Set<ClassFileInfo> classes = new HashSet<ClassFileInfo>();
    private String path;

    ClassJar(String path, TaskMonitor monitor) throws CancelledException {
        this.path = path;
        ClassJar.loadUserPluginPaths();
        this.scanJar(monitor);
    }

    @Override
    public void getClasses(List<ClassFileInfo> list, TaskMonitor monitor) {
        list.addAll(this.classes);
    }

    private void scanJar(TaskMonitor monitor) throws CancelledException {
        File file = new File(this.path);
        try (JarFile jarFile = new JarFile(file);){
            String pathName = jarFile.getName();
            int separatorIndex = pathName.lastIndexOf(File.separator);
            String jarFilename = pathName.substring(separatorIndex + 1);
            monitor.setMessage("Scanning jar: " + jarFilename);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                monitor.checkCancelled();
                this.processClassFiles(entries.nextElement());
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error reading jarFile: " + this.path), (Throwable)e);
        }
    }

    static boolean ignoreJar(String pathName) {
        if (StringUtilities.containsAnyIgnoreCase(pathName, "ExternalLibraries", "caches", "flatrepo")) {
            return true;
        }
        if (SystemUtilities.isInDevelopmentMode()) {
            return false;
        }
        String forwardSlashedPathName = pathName.replaceAll("\\\\", "/");
        if (ClassJar.isUserPluginJar(forwardSlashedPathName)) {
            return false;
        }
        if (ClassJar.isPatchJar(forwardSlashedPathName)) {
            return false;
        }
        return !ClassJar.isModuleDependencyJar(forwardSlashedPathName);
    }

    private static boolean isUserPluginJar(String pathName) {
        return USER_PLUGIN_PATHS.contains(pathName);
    }

    private static boolean isPatchJar(String pathName) {
        String jarDirectory = FilenameUtils.getFullPathNoEndSeparator((String)pathName);
        return jarDirectory.equalsIgnoreCase(PATCH_DIR_PATH_FORWARD_SLASHED);
    }

    private static boolean isModuleDependencyJar(String pathName) {
        if (ClassSearcher.SEARCH_ALL_JARS) {
            return true;
        }
        Matcher matcher = ANY_MODULE_LIB_JAR_FILE_PATTERN.matcher(pathName);
        if (!matcher.matches()) {
            return false;
        }
        String moduleName = matcher.group(1);
        String jarName = matcher.group(2);
        return jarName.startsWith(moduleName);
    }

    private void processClassFiles(JarEntry entry) {
        String name = entry.getName();
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(0, name.indexOf(".class"));
        String epName = ClassSearcher.getExtensionPointSuffix(name = name.replace('/', '.'));
        if (epName != null) {
            this.classes.add(new ClassFileInfo(this.path, name, epName));
        }
    }

    public String toString() {
        return this.path;
    }

    private static String getPatchDirPath() {
        ApplicationLayout layout = Application.getApplicationLayout();
        ResourceFile patchDir = layout.getPatchDir();
        if (patchDir == null) {
            return "<no patch dir>";
        }
        String patchPath = patchDir.getAbsolutePath();
        String forwardSlashed = patchPath.replaceAll("\\\\", "/");
        return forwardSlashed;
    }

    private static Set<String> loadUserPluginPaths() {
        String[] paths;
        HashSet<String> result = new HashSet<String>();
        for (String pathName : paths = Preferences.getPluginPaths()) {
            String forwardSlashed = pathName.replaceAll("\\\\", "/").toLowerCase();
            result.add(forwardSlashed);
        }
        return Collections.unmodifiableSet(result);
    }
}

