/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.timer;

import ghidra.util.Msg;
import ghidra.util.timer.GTimerMonitor;
import java.util.Timer;
import java.util.TimerTask;

public class GTimer {
    private static Timer timer;
    private static GTimerMonitor DO_NOTHING_MONITOR;

    public static GTimerMonitor scheduleRunnable(long delay, Runnable callback) {
        if (delay < 0L) {
            return DO_NOTHING_MONITOR;
        }
        GTimerTask gTimerTask = new GTimerTask(callback);
        GTimer.getTimer().schedule((TimerTask)gTimerTask, delay);
        return gTimerTask;
    }

    public static GTimerMonitor scheduleRepeatingRunnable(long delay, long period, Runnable callback) {
        if (delay < 0L) {
            return DO_NOTHING_MONITOR;
        }
        GTimerTask gTimerTask = new GTimerTask(callback);
        GTimer.getTimer().schedule((TimerTask)gTimerTask, delay, period);
        return gTimerTask;
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("GTimer", true);
        }
        return timer;
    }

    static {
        DO_NOTHING_MONITOR = GTimerMonitor.DUMMY;
    }

    static class GTimerTask
    extends TimerTask
    implements GTimerMonitor {
        private final Runnable runnable;
        private transient boolean wasCancelled;
        private transient boolean wasRun;

        GTimerTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
                this.wasRun = true;
            }
            catch (Throwable t) {
                Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)"Unexpected exception running timer task", (Throwable)t);
            }
        }

        @Override
        public boolean didRun() {
            return this.wasRun;
        }

        @Override
        public boolean wasCancelled() {
            return this.wasCancelled;
        }

        @Override
        public boolean cancel() {
            this.wasCancelled = super.cancel();
            return this.wasCancelled;
        }
    }
}

