/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.Objects;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.Point;

public class Rectangle {
    public final double x;
    public final double y;
    public final double width;
    public final double height;
    public final double maxX;
    public final double maxY;
    public static Rectangle IDENTITY = new Rectangle(0.0, 0.0, 0.0, 0.0);

    public static Rectangle of(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle of(int width, int height) {
        return new Rectangle(0.0, 0.0, width, height);
    }

    public static Rectangle of(double x, double y, double width, double height) {
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle from(Point min, Point max) {
        return new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
    }

    public Rectangle(double x, double y, double width, double height) {
        if (width < 0.0 || height < 0.0) {
            throw new IllegalArgumentException("width and height must be non-negative");
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.maxX = x + width;
        this.maxY = y + height;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public boolean intersects(Rectangle other) {
        return this.maxX >= other.x && other.maxX >= this.x && this.maxY >= other.y && other.maxY >= this.y;
    }

    public Rectangle intersect(Rectangle other) {
        if (this.intersects(other)) {
            return Rectangle.from(Point.of(Math.max(this.x, other.x), Math.max(this.y, other.y)), Point.of(Math.min(this.maxX, other.maxX), Math.min(this.maxY, other.maxY)));
        }
        return Rectangle.of(0, 0);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Point min() {
        return Point.of(this.x, this.y);
    }

    public Point max() {
        return Point.of(this.x, this.y).add(this.width, this.height);
    }

    public boolean contains(double ox, double oy) {
        if (ox < this.x) {
            return false;
        }
        if (ox > this.maxX) {
            return false;
        }
        if (oy < this.y) {
            return false;
        }
        return !(oy > this.maxY);
    }

    public Rectangle offset(double x, double y) {
        return new Rectangle(this.x + x, this.y + y, this.width, this.height);
    }

    public Rectangle union(double newX, double newY) {
        double x1 = Math.min(this.x, newX);
        double x2 = Math.max(this.maxX, newX);
        double y1 = Math.min(this.y, newY);
        double y2 = Math.max(this.maxY, newY);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle union(Rectangle other) {
        double minX = Math.min(this.x, other.x);
        double minY = Math.min(this.y, other.y);
        double maxX = Math.max(this.maxX, other.maxX);
        double maxY = Math.max(this.maxY, other.maxY);
        return Rectangle.of(minX, minY, maxX - minX, maxY - minY);
    }

    public Dimension getSize() {
        return Dimension.of((int)this.width, (int)this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        return Double.compare(rectangle.x, this.x) == 0 && Double.compare(rectangle.y, this.y) == 0 && Double.compare(rectangle.width, this.width) == 0 && Double.compare(rectangle.height, this.height) == 0 && Double.compare(rectangle.maxX, this.maxX) == 0 && Double.compare(rectangle.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height, this.maxX, this.maxY);
    }

    public String toString() {
        return "Rectangle{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", maxX=" + this.maxX + ", maxY=" + this.maxY + "}";
    }
}

