/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseStateItem;
import ghidra.app.plugin.assembler.sleigh.util.AsmUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class AssemblyParseState
implements Comparable<AssemblyParseState> {
    private final AssemblyGrammar grammar;
    private final Set<AssemblyParseStateItem> kernel = new LinkedHashSet<AssemblyParseStateItem>();
    private Set<AssemblyParseStateItem> closure;

    public AssemblyParseState(AssemblyGrammar grammar) {
        this.grammar = grammar;
    }

    public AssemblyParseState(AssemblyGrammar grammar, AssemblyParseStateItem item) {
        this(grammar);
        this.kernel.add(item);
    }

    public Set<AssemblyParseStateItem> getKernel() {
        return this.kernel;
    }

    public Set<AssemblyParseStateItem> getClosure() {
        if (this.closure != null) {
            return this.closure;
        }
        this.closure = new LinkedHashSet<AssemblyParseStateItem>(this.kernel);
        LinkedHashSet<AssemblyParseStateItem> newItems = new LinkedHashSet<AssemblyParseStateItem>();
        do {
            newItems.clear();
            for (AssemblyParseStateItem item : this.closure) {
                newItems.addAll(item.getClosure(this.grammar));
            }
        } while (this.closure.addAll(newItems));
        return this.closure;
    }

    public boolean equals(Object that) {
        if (!(that instanceof AssemblyParseState)) {
            return false;
        }
        return this.kernel.equals(((AssemblyParseState)that).kernel);
    }

    @Override
    public int compareTo(AssemblyParseState that) {
        int result = this.kernel.size() - that.kernel.size();
        if (result != 0) {
            return result;
        }
        result = AsmUtil.compareInOrder(this.kernel, that.kernel);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<AssemblyParseStateItem> it = this.kernel.iterator();
        if (!it.hasNext()) {
            return "";
        }
        sb.append("\n\n");
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append("\n");
            sb.append(it.next());
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 0;
        for (AssemblyParseStateItem item : this.kernel) {
            result *= 31;
            result += item.hashCode();
        }
        return result;
    }
}

