/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.set.AbstractSetDecorator;

public class AssemblyResolutionResults
extends AbstractSetDecorator<AssemblyResolution> {
    protected static final DbgTimer DBG = AbstractAssemblyTreeResolver.DBG;
    protected final Set<AssemblyResolution> resolutions;

    public AssemblyResolutionResults() {
        this.resolutions = new LinkedHashSet<AssemblyResolution>();
    }

    protected AssemblyResolutionResults(Set<AssemblyResolution> resolutions) {
        this.resolutions = resolutions;
    }

    public boolean add(AssemblyResolution ar) {
        return this.resolutions.add(ar);
    }

    public void absorb(AssemblyResolutionResults that) {
        this.resolutions.addAll(that.resolutions);
    }

    public boolean addAll(Collection<? extends AssemblyResolution> c) {
        return this.resolutions.addAll(c);
    }

    public Set<AssemblyResolution> getResolutions() {
        return Collections.unmodifiableSet(this.resolutions);
    }

    protected Set<AssemblyResolution> decorated() {
        return this.getResolutions();
    }

    public boolean remove(AssemblyResolution ar) {
        return this.resolutions.remove(ar);
    }

    protected AssemblyResolutionResults apply(AbstractAssemblyResolutionFactory<?, ?> factory, Applicator applicator) {
        AssemblyResolutionResults results = factory.newAssemblyResolutionResults();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AssemblyResolution res = (AssemblyResolution)iterator.next();
            if (res.isError()) {
                results.add(res);
                continue;
            }
            AssemblyResolvedPatterns rp = (AssemblyResolvedPatterns)res;
            DBG.println("Current: " + rp.lineToString());
            for (AssemblyResolution assemblyResolution : applicator.getPatterns(rp)) {
                DBG.println("Pattern: " + assemblyResolution.lineToString());
                AssemblyResolvedPatterns combined = applicator.combine(rp, assemblyResolution);
                DBG.println("Combined: " + (combined == null ? "(null)" : combined.lineToString()));
                if (combined == null) {
                    results.add(factory.error(applicator.describeError(rp, assemblyResolution), assemblyResolution));
                    continue;
                }
                results.add(applicator.finish(combined));
            }
        }
        return results;
    }

    protected AssemblyResolutionResults apply(AbstractAssemblyResolutionFactory<?, ?> factory, Function<AssemblyResolvedPatterns, AssemblyResolution> function) {
        return this.stream().map(res -> {
            if (res instanceof AssemblyResolvedBackfill) {
                throw new AssertionError();
            }
            if (res instanceof AssemblyResolvedError) {
                AssemblyResolvedError err = (AssemblyResolvedError)res;
                return err;
            }
            if (res instanceof AssemblyResolvedPatterns) {
                AssemblyResolvedPatterns rp = (AssemblyResolvedPatterns)res;
                return (AssemblyResolution)function.apply(rp);
            }
            throw new AssertionError();
        }).collect(Collectors.toCollection(factory::newAssemblyResolutionResults));
    }

    public static interface Applicator {
        public Iterable<? extends AssemblyResolution> getPatterns(AssemblyResolvedPatterns var1);

        default public AssemblyResolvedPatterns setDescription(AssemblyResolvedPatterns res, AssemblyResolution from) {
            AssemblyResolvedPatterns temp = res.withDescription(from.getDescription());
            return temp;
        }

        default public AssemblyResolvedPatterns setRight(AssemblyResolvedPatterns res, AssemblyResolvedPatterns cur) {
            return res.withRight(cur);
        }

        default public AssemblyResolvedPatterns combineConstructor(AssemblyResolvedPatterns cur, AssemblyResolvedPatterns pat) {
            AssemblyResolvedPatterns combined = cur.combine(pat);
            if (combined == null) {
                return null;
            }
            return this.setRight(this.setDescription(combined, pat), cur);
        }

        default public AssemblyResolvedPatterns combineBackfill(AssemblyResolvedPatterns cur, AssemblyResolvedBackfill bf) {
            AssemblyResolvedPatterns combined = cur.combine(bf);
            return this.setRight(this.setDescription(combined, bf), cur);
        }

        default public AssemblyResolvedPatterns combine(AssemblyResolvedPatterns cur, AssemblyResolution pat) {
            if (pat.isError()) {
                throw new AssertionError();
            }
            if (pat.isBackfill()) {
                return this.combineBackfill(cur, (AssemblyResolvedBackfill)pat);
            }
            return this.combineConstructor(cur, (AssemblyResolvedPatterns)pat);
        }

        public String describeError(AssemblyResolvedPatterns var1, AssemblyResolution var2);

        default public AssemblyResolution finish(AssemblyResolvedPatterns resolved) {
            return resolved;
        }
    }
}

