/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.PseudoData;
import ghidra.app.util.PseudoDisassemblerContext;
import ghidra.app.util.PseudoFlowProcessor;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.RepeatInstructionByteTracker;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class PseudoDisassembler {
    private static final String LOW_BIT_CODE_MODE_REGISTER_NAME = "LowBitCodeMode";
    private static final int DEFAULT_MAX_INSTRUCTIONS = 4000;
    Program program = null;
    private ProgramContext programContext = null;
    private Language language = null;
    private Memory memory = null;
    private int pointerSize;
    static final int MAX_REPEAT_BYTES_LIMIT = 4;
    private int maxInstructions = 4000;
    private boolean respectExecuteFlag = false;
    private int lastCheckValidDisassemblyCount;

    public PseudoDisassembler(Program program) {
        this.program = program;
        this.memory = program.getMemory();
        this.language = program.getLanguage();
        this.pointerSize = program.getDefaultPointerSize();
        this.programContext = program.getProgramContext();
    }

    public void setMaxInstructions(int maxNumInstructions) {
        this.maxInstructions = maxNumInstructions;
    }

    public int getLastCheckValidInstructionCount() {
        return this.lastCheckValidDisassemblyCount;
    }

    public void setRespectExecuteFlag(boolean respect) {
        this.respectExecuteFlag = respect;
    }

    public PseudoInstruction disassemble(Address addr) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException {
        PseudoDisassemblerContext procContext = new PseudoDisassemblerContext(this.programContext);
        procContext.flowStart(addr);
        return this.disassemble(addr, procContext, false);
    }

    public PseudoInstruction disassemble(Address addr, PseudoDisassemblerContext disassemblerContext, boolean isInDelaySlot) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException {
        PseudoInstruction instr;
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.memory, addr);
        try {
            memBuffer.getByte(0);
        }
        catch (Exception e) {
            return null;
        }
        InstructionPrototype prototype = null;
        try {
            prototype = this.language.parse(memBuffer, disassemblerContext, isInDelaySlot);
        }
        catch (UnknownInstructionException unknownExc) {
            return null;
        }
        if (prototype == null) {
            return null;
        }
        try {
            instr = new PseudoInstruction(this.program, addr, prototype, (MemBuffer)memBuffer, (ProcessorContext)disassemblerContext);
        }
        catch (Exception e) {
            return null;
        }
        return instr;
    }

    public PseudoInstruction disassemble(Address addr, byte[] bytes) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException {
        PseudoDisassemblerContext procContext = new PseudoDisassemblerContext(this.programContext);
        return this.disassemble(addr, bytes, procContext);
    }

    public PseudoInstruction disassemble(Address addr, byte[] bytes, PseudoDisassemblerContext disassemblerContext) throws InsufficientBytesException, UnknownInstructionException, UnknownContextException {
        PseudoInstruction instr;
        ByteMemBufferImpl memBuffer = new ByteMemBufferImpl(addr, bytes, this.language.isBigEndian());
        try {
            memBuffer.getByte(0);
        }
        catch (Exception e) {
            return null;
        }
        InstructionPrototype prototype = null;
        disassemblerContext.flowStart(addr);
        prototype = this.language.parse(memBuffer, disassemblerContext, false);
        if (prototype == null) {
            return null;
        }
        try {
            instr = new PseudoInstruction(this.program, addr, prototype, (MemBuffer)memBuffer, (ProcessorContext)disassemblerContext);
        }
        catch (AddressOverflowException e) {
            throw new InsufficientBytesException("failed to build pseudo instruction at " + String.valueOf(addr) + ": " + e.getMessage());
        }
        return instr;
    }

    public PseudoData applyDataType(Address addr, DataType dt) {
        Memory memory = this.program.getMemory();
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(memory, addr);
        try {
            memBuffer.getByte(0);
            return new PseudoData(this.program, addr, dt, (MemBuffer)memBuffer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Address getIndirectAddr(Address toAddr) {
        PseudoData data = this.applyDataType(toAddr, PointerDataType.getPointer(null, toAddr.getPointerSize()));
        if (data == null) {
            return null;
        }
        Object objVal = data.getValue();
        if (!(objVal instanceof Address)) {
            return null;
        }
        Address ptrAddr = (Address)objVal;
        return ptrAddr;
    }

    public boolean isValidSubroutine(Address entryPoint) {
        return this.isValidSubroutine(entryPoint, false);
    }

    public boolean isValidSubroutine(Address entryPoint, boolean allowExistingCode) {
        return this.checkValidSubroutine(entryPoint, allowExistingCode);
    }

    public boolean isValidSubroutine(Address entryPoint, boolean allowExistingCode, boolean mustTerminate) {
        return this.checkValidSubroutine(entryPoint, allowExistingCode, mustTerminate);
    }

    public boolean isValidCode(Address entryPoint) {
        boolean valid = this.checkValidSubroutine(entryPoint, true, false);
        return valid;
    }

    public boolean isValidCode(Address entryPoint, PseudoDisassemblerContext context) {
        boolean valid = this.checkValidSubroutine(entryPoint, context, true, false);
        return valid;
    }

    public AddressSet followSubFlows(Address entryPoint, int maxInstr, PseudoFlowProcessor processor) {
        PseudoDisassemblerContext procContext = new PseudoDisassemblerContext(this.programContext);
        return this.followSubFlows(entryPoint, procContext, maxInstr, processor);
    }

    public AddressSet followSubFlows(Address entryPoint, PseudoDisassemblerContext procContext, int maxInstr, PseudoFlowProcessor processor) {
        AddressSet body = new AddressSet();
        AddressSet instrStarts = new AddressSet();
        Address target = entryPoint = PseudoDisassembler.setTargetContextForDisassembly(procContext, entryPoint);
        ArrayList<Address> targetList = new ArrayList<Address>();
        ArrayList<Address> untriedTargetList = new ArrayList<Address>();
        try {
            Address tempAddr = entryPoint;
            byte[] ptrbytes = new byte[this.pointerSize];
            if (this.memory.getBytes(tempAddr, ptrbytes) == ptrbytes.length) {
                boolean allZero = true;
                for (byte ptrbyte : ptrbytes) {
                    if (ptrbyte == 0) continue;
                    allZero = false;
                    break;
                }
                if (allZero) {
                    return body;
                }
            }
        }
        catch (MemoryAccessException e1) {
            return body;
        }
        catch (AddressOutOfBoundsException e2) {
            return body;
        }
        procContext.flowStart(entryPoint);
        try {
            for (int i = 0; target != null && i < maxInstr; ++i) {
                Address[] flows;
                PseudoInstruction instr = this.disassemble(target, procContext, false);
                boolean doContinue = processor.process(instr);
                if (!doContinue) {
                    return body;
                }
                if (instr == null) {
                    target = this.getNextTarget(body, untriedTargetList);
                    continue;
                }
                Address newTarget = null;
                body.addRange(instr.getMinAddress(), instr.getMaxAddress());
                instrStarts.addRange(instr.getMinAddress(), instr.getMinAddress());
                if (!processor.followFlows(instr)) {
                    target = this.getNextTarget(body, untriedTargetList);
                    continue;
                }
                if (instr.hasFallthrough()) {
                    newTarget = instr.getFallThrough();
                } else {
                    Address[] flows2;
                    Address nextAddr = instr.getMaxAddress().next();
                    if (targetList.contains(nextAddr)) {
                        newTarget = nextAddr;
                    } else if (instr.getFlowType().isJump() && (flows2 = instr.getFlows()) != null) {
                        Address[] addressArray = flows2;
                        int n = addressArray.length;
                        for (int j = 0; j < n; ++j) {
                            Address address = addressArray[j];
                            if (body.contains(address)) continue;
                            newTarget = address;
                            break;
                        }
                    }
                    if (newTarget == null) {
                        newTarget = this.getNextTarget(body, untriedTargetList);
                    }
                }
                if (instr.getFlowType().isJump() && (flows = instr.getFlows()) != null) {
                    for (Address address : flows) {
                        targetList.add(address);
                        untriedTargetList.add(address);
                    }
                }
                target = newTarget;
            }
        }
        catch (InsufficientBytesException e) {
            processor.process(null);
        }
        catch (UnknownInstructionException e) {
            processor.process(null);
        }
        catch (UnknownContextException e) {
            processor.process(null);
        }
        return body;
    }

    private Address getNextTarget(AddressSet body, ArrayList<Address> untriedTargetList) {
        Address newTarget = null;
        if (!untriedTargetList.isEmpty()) {
            Iterator<Address> iter = untriedTargetList.iterator();
            while (iter.hasNext()) {
                Address possibleTarget = iter.next();
                if (body.contains(possibleTarget)) continue;
                newTarget = possibleTarget;
                iter.remove();
                break;
            }
        }
        return newTarget;
    }

    private boolean checkValidSubroutine(Address entryPoint, boolean allowExistingInstructions) {
        return this.checkValidSubroutine(entryPoint, allowExistingInstructions, true);
    }

    private boolean checkValidSubroutine(Address entryPoint, boolean allowExistingInstructions, boolean mustTerminate) {
        return this.checkValidSubroutine(entryPoint, allowExistingInstructions, mustTerminate, false);
    }

    public boolean checkValidSubroutine(Address entryPoint, boolean allowExistingInstructions, boolean mustTerminate, boolean requireContiguous) {
        PseudoDisassemblerContext procContext = new PseudoDisassemblerContext(this.programContext);
        return this.checkValidSubroutine(entryPoint, procContext, allowExistingInstructions, mustTerminate, requireContiguous);
    }

    public boolean checkValidSubroutine(Address entryPoint, PseudoDisassemblerContext procContext, boolean allowExistingInstructions, boolean mustTerminate) {
        return this.checkValidSubroutine(entryPoint, procContext, allowExistingInstructions, mustTerminate, false);
    }

    public boolean checkValidSubroutine(Address entryPoint, PseudoDisassemblerContext procContext, boolean allowExistingInstructions, boolean mustTerminate, boolean requireContiguous) {
        AddressSet contiguousSet = new AddressSet();
        this.lastCheckValidDisassemblyCount = 0;
        if (!entryPoint.isMemoryAddress()) {
            return false;
        }
        AddressSet body = new AddressSet();
        AddressSet instrStarts = new AddressSet();
        AddressSetView execSet = this.memory.getExecuteSet();
        Address target = entryPoint = PseudoDisassembler.setTargetContextForDisassembly(procContext, entryPoint);
        ArrayList<Address> targetList = new ArrayList<Address>();
        ArrayList<Address> untriedTargetList = new ArrayList<Address>();
        boolean didTerminate = false;
        boolean didCallValidSubroutine = false;
        try {
            if (this.memory.getLong(entryPoint) == 0L) {
                return false;
            }
        }
        catch (MemoryAccessException e1) {
            return false;
        }
        catch (AddressOutOfBoundsException e2) {
            return false;
        }
        RepeatInstructionByteTracker repeatInstructionByteTracker = new RepeatInstructionByteTracker(4, null);
        procContext.flowStart(entryPoint);
        try {
            for (int i = 0; target != null && i < this.maxInstructions; ++i) {
                Address[] flows;
                int n;
                Address[] flows2;
                if (target.compareTo(procContext.getAddress()) < 0) {
                    procContext.copyToFutureFlowState(target);
                    procContext.flowEnd(procContext.getAddress());
                    procContext.flowStart(target);
                } else {
                    procContext.flowToAddress(target);
                }
                PseudoInstruction instr = this.disassemble(target, procContext, false);
                if (instr == null) {
                    MemoryBlock block = this.memory.getBlock(target);
                    if (block == null || block.isInitialized() || !block.getName().equals("EXTERNAL")) {
                        return false;
                    }
                    targetList.remove(target);
                    target = this.getNextTarget(body, untriedTargetList);
                    repeatInstructionByteTracker.reset();
                    continue;
                }
                if (contiguousSet.isEmpty() || !requireContiguous || contiguousSet.getFirstRange().getMaxAddress().isSuccessor(target)) {
                    contiguousSet.add(instr.getMinAddress(), instr.getMaxAddress());
                    ++this.lastCheckValidDisassemblyCount;
                }
                if (repeatInstructionByteTracker.exceedsRepeatBytePattern(instr)) {
                    return false;
                }
                Address maxAddr = instr.getMaxAddress();
                Address newTarget = null;
                body.addRange(target, maxAddr);
                instrStarts.add(target);
                int delaySlots = instr.getDelaySlotDepth();
                Address addr = maxAddr;
                for (int delaySlot = 0; delaySlot < delaySlots; ++delaySlot) {
                    try {
                        addr = addr.addNoWrap(1L);
                    }
                    catch (AddressOverflowException e) {
                        return false;
                    }
                    procContext.flowToAddress(addr);
                    PseudoInstruction dsInstr = this.disassemble(addr, procContext, true);
                    if (dsInstr == null) {
                        return false;
                    }
                    maxAddr = dsInstr.getMaxAddress();
                    body.addRange(addr, maxAddr);
                    instrStarts.add(addr);
                    addr = maxAddr;
                }
                FlowType flowType = instr.getFlowType();
                if (flowType.isTerminal()) {
                    didTerminate |= this.isReallyReturn(instr);
                }
                Address fallThru = null;
                if (instr.hasFallthrough()) {
                    if (this.checkNonReturning(this.program, flowType, instr)) {
                        target = this.getNextTarget(body, untriedTargetList);
                        repeatInstructionByteTracker.reset();
                        continue;
                    }
                    fallThru = newTarget = instr.getFallThrough();
                } else {
                    Address nextAddr = maxAddr.next();
                    if (targetList.contains(nextAddr)) {
                        newTarget = nextAddr;
                    } else if (flowType.isJump() && (flows2 = instr.getFlows()) != null) {
                        Address[] addressArray = flows2;
                        n = addressArray.length;
                        for (int j = 0; j < n; ++j) {
                            Address address = addressArray[j];
                            if (body.contains(address)) continue;
                            newTarget = address;
                            break;
                        }
                    }
                    if (newTarget == null) {
                        newTarget = this.getNextTarget(body, untriedTargetList);
                        repeatInstructionByteTracker.reset();
                    }
                }
                if (flowType.isJump()) {
                    flows = instr.getFlows();
                    if (flows != null && flows.length > 0) {
                        flows2 = flows;
                        int n2 = flows2.length;
                        for (n = 0; n < n2; ++n) {
                            Address address = flows2[n];
                            if (fallThru != null && address.equals(fallThru) & !instr.getPrototype().hasDelaySlots()) {
                                return false;
                            }
                            Function func = null;
                            if (this.program != null) {
                                func = this.program.getFunctionManager().getFunctionAt(address);
                            }
                            if (func != null) {
                                didCallValidSubroutine = true;
                                newTarget = this.getNextTarget(body, untriedTargetList);
                                repeatInstructionByteTracker.reset();
                                continue;
                            }
                            targetList.add(address);
                            untriedTargetList.add(address);
                        }
                    } else if (flowType.isComputed()) {
                        didTerminate = true;
                    }
                }
                if (flowType.isCall() || flowType.isJump() && flowType.isComputed()) {
                    Reference[] refsFrom;
                    flows = instr.getFlows();
                    if ((flows == null || flows.length == 0) && (refsFrom = instr.getReferencesFrom()) != null && refsFrom.length > 0) {
                        flows = new Address[]{refsFrom[0].getToAddress()};
                    }
                    if (flows != null && flows.length > 0) {
                        Address[] addressArray = flows;
                        int n3 = addressArray.length;
                        for (n = 0; n < n3; ++n) {
                            MemoryBlock block;
                            Symbol primary;
                            Address flow = addressArray[n];
                            if (this.program != null && (primary = this.program.getSymbolTable().getPrimarySymbol(flow)) != null && primary.getSymbolType() == SymbolType.FUNCTION) {
                                didCallValidSubroutine = true;
                            }
                            if (!this.respectExecuteFlag || execSet.isEmpty() || execSet.contains(flow) || flow.isExternalAddress() || (block = this.memory.getBlock(flow)) == null || !block.isRead() || "EXTERNAL".equals(block.getName())) continue;
                            return false;
                        }
                    }
                }
                target = newTarget;
            }
        }
        catch (InsufficientBytesException e) {
            return false;
        }
        catch (UnknownInstructionException e) {
            return false;
        }
        catch (UnknownContextException e) {
            return false;
        }
        Iterator iter = targetList.iterator();
        while (iter.hasNext()) {
            Address targetAddr = (Address)iter.next();
            if (body.contains(targetAddr)) {
                iter.remove();
                if (instrStarts.contains(targetAddr)) continue;
                return false;
            }
            if (this.maxInstructions <= 0) continue;
            iter.remove();
        }
        if (targetList.isEmpty() && (didTerminate || !mustTerminate || didCallValidSubroutine)) {
            return this.checkPseudoBody(entryPoint, body, instrStarts, allowExistingInstructions, didCallValidSubroutine);
        }
        return false;
    }

    private boolean checkNonReturning(Program program, FlowType flowType, PseudoInstruction instr) {
        if (!flowType.isCall()) {
            return false;
        }
        Address[] flows = instr.getFlows();
        Function func = null;
        if (flows.length > 0) {
            if (program != null) {
                func = program.getFunctionManager().getFunctionAt(flows[0]);
            }
        } else if (flowType.isComputed() & !flowType.isConditional()) {
            for (int opIndex = 0; opIndex < instr.getNumOperands(); ++opIndex) {
                Address addr;
                RefType operandRefType = instr.getOperandRefType(opIndex);
                if (!operandRefType.isIndirect() || (addr = instr.getAddress(opIndex)) == null) continue;
                func = program.getFunctionManager().getReferencedFunction(addr);
            }
        }
        return func != null && func.hasNoReturn();
    }

    private boolean isReallyReturn(Instruction instr) {
        PcodeOp[] pcode;
        for (PcodeOp element : pcode = instr.getPcode()) {
            if (element.getOpcode() != 10) continue;
            return true;
        }
        return false;
    }

    private boolean checkPseudoBody(Address entry, AddressSet body, AddressSet starts, boolean allowExistingInstructions, boolean didCallValidSubroutine) {
        AddressIterator addrIter;
        if (this.program == null) {
            return true;
        }
        AddressSetView execSet = this.memory.getExecuteSet();
        if (this.respectExecuteFlag && !execSet.isEmpty() && !execSet.contains(body)) {
            return false;
        }
        if (this.program.getListing().getDefinedData(body, true).hasNext()) {
            return false;
        }
        boolean canHaveOffcutEntry = PseudoDisassembler.hasLowBitCodeModeInAddrValues(this.program);
        AddressSet strictlyBody = body.subtract(starts);
        if (canHaveOffcutEntry) {
            strictlyBody.deleteRange(entry, entry.add(1L));
        }
        if ((addrIter = this.program.getReferenceManager().getReferenceDestinationIterator(strictlyBody, true)).hasNext()) {
            return false;
        }
        if (allowExistingInstructions) {
            return true;
        }
        if (this.program.getListing().getInstructions(body, true).hasNext()) {
            return false;
        }
        if (!didCallValidSubroutine && starts.getMinAddress().equals(starts.getMaxAddress())) {
            return false;
        }
        AddressIterator iter = this.program.getReferenceManager().getReferenceDestinationIterator(body, true);
        while (iter.hasNext()) {
            Address toAddr = iter.next();
            if (toAddr.equals(entry) || entry.add(1L).equals(toAddr) && PseudoDisassembler.hasLowBitCodeModeInAddrValues(this.program)) continue;
            return false;
        }
        return true;
    }

    public static Address getNormalizedDisassemblyAddress(Program program, Address addr) {
        if (!addr.isMemoryAddress()) {
            return addr;
        }
        Register lowBitCodeMode = program.getRegister(LOW_BIT_CODE_MODE_REGISTER_NAME);
        if (lowBitCodeMode == null) {
            return addr;
        }
        if ((addr.getOffset() & 1L) == 0L) {
            return addr;
        }
        return addr.getNewAddress(addr.getOffset() & 0xFFFFFFFFFFFFFFFEL);
    }

    public static RegisterValue getTargetContextRegisterValueForDisassembly(Program program, Address addr) {
        Register lowBitCodeMode = program.getRegister(LOW_BIT_CODE_MODE_REGISTER_NAME);
        if (lowBitCodeMode == null) {
            return null;
        }
        long offset = addr.getOffset();
        if ((offset & 1L) == 1L) {
            return new RegisterValue(lowBitCodeMode, BigInteger.ONE);
        }
        return null;
    }

    public static boolean hasLowBitCodeModeInAddrValues(Program program) {
        Register lowBitCodeMode = program.getRegister(LOW_BIT_CODE_MODE_REGISTER_NAME);
        return lowBitCodeMode != null;
    }

    public static Address setTargetContextForDisassembly(Program program, Address addr) {
        if (!addr.isMemoryAddress()) {
            Msg.error(PseudoDisassembler.class, (Object)("Invalid attempt to adjust disassembler context at " + addr.toString(true)));
            return addr;
        }
        long offset = addr.getOffset();
        if ((offset & 1L) == 0L) {
            return addr;
        }
        Register lowBitCodeMode = program.getRegister(LOW_BIT_CODE_MODE_REGISTER_NAME);
        if (lowBitCodeMode == null) {
            return addr;
        }
        addr = addr.getNewAddress(addr.getOffset() & 0xFFFFFFFFFFFFFFFEL);
        try {
            program.getProgramContext().setValue(lowBitCodeMode, addr, addr, BigInteger.ONE);
        }
        catch (ContextChangeException contextChangeException) {
            // empty catch block
        }
        return addr;
    }

    public static Address setTargetContextForDisassembly(DisassemblerContext procContext, Address addr) {
        if (!addr.isMemoryAddress()) {
            Msg.error(PseudoDisassembler.class, (Object)("Invalid attempt to adjust disassembler context at " + addr.toString(true)));
            return addr;
        }
        long offset = addr.getOffset();
        if ((offset & 1L) == 0L) {
            return addr;
        }
        Register lowBitCodeMode = procContext.getRegister(LOW_BIT_CODE_MODE_REGISTER_NAME);
        if (lowBitCodeMode == null) {
            return addr;
        }
        addr = addr.getNewAddress(addr.getOffset() & 0xFFFFFFFFFFFFFFFEL);
        RegisterValue val = new RegisterValue(lowBitCodeMode, BigInteger.ONE);
        procContext.setFutureRegisterValue(addr, val);
        return addr;
    }
}

