/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.code.CommentsDBAdapterV0;
import ghidra.program.database.code.CommentsDBAdapterV1;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CommentType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CommentsDBAdapter {
    static final String COMMENTS_TABLE_NAME = "Comments";
    static final Schema COMMENTS_SCHEMA;
    static final int EOL_COMMENT_COL;
    static final int PRE_COMMENT_COL;
    static final int POST_COMMENT_COL;
    static final int PLATE_COMMENT_COL;
    static final int REPEATABLE_COMMENT_COL;
    static final int COMMENT_COL_COUNT = 5;
    static final String[] NAMES;

    CommentsDBAdapter() {
    }

    static CommentsDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new CommentsDBAdapterV1(dbHandle, addrMap, true);
        }
        try {
            CommentsDBAdapterV1 adapter = new CommentsDBAdapterV1(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            CommentsDBAdapter adapter = CommentsDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == OpenMode.UPGRADE) {
                adapter = CommentsDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static CommentsDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new CommentsDBAdapterV1(handle, addrMap.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            return new CommentsDBAdapterV0(handle, addrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommentsDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, CommentsDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Comments...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            CommentsDBAdapterV1 tmpAdapter = new CommentsDBAdapterV1(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getKey());
                rec.setKey(addrMap.getKey(addr, true));
                ((CommentsDBAdapter)tmpAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(COMMENTS_TABLE_NAME);
            CommentsDBAdapterV1 newAdapter = new CommentsDBAdapterV1(dbHandle, addrMap, true);
            iter = ((CommentsDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                ((CommentsDBAdapter)newAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            CommentsDBAdapterV1 commentsDBAdapterV1 = newAdapter;
            return commentsDBAdapterV1;
        }
    }

    abstract int getRecordCount() throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract DBRecord createRecord(long var1, int var3, String var4) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    abstract boolean deleteRecords(Address var1, Address var2) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract RecordIterator getRecords(Address var1, Address var2, boolean var3) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract AddressKeyIterator getKeys(Address var1, Address var2, boolean var3) throws IOException;

    abstract void putRecord(DBRecord var1) throws IOException;

    abstract RecordIterator getRecords(Address var1) throws IOException;

    abstract AddressKeyIterator getKeys(AddressSetView var1, boolean var2) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;

    static {
        EOL_COMMENT_COL = CommentType.EOL.ordinal();
        PRE_COMMENT_COL = CommentType.PRE.ordinal();
        POST_COMMENT_COL = CommentType.POST.ordinal();
        PLATE_COMMENT_COL = CommentType.PLATE.ordinal();
        REPEATABLE_COMMENT_COL = CommentType.REPEATABLE.ordinal();
        NAMES = new String[5];
        CommentsDBAdapter.NAMES[CommentsDBAdapter.EOL_COMMENT_COL] = "EOL";
        CommentsDBAdapter.NAMES[CommentsDBAdapter.PRE_COMMENT_COL] = "Pre";
        CommentsDBAdapter.NAMES[CommentsDBAdapter.POST_COMMENT_COL] = "Post";
        CommentsDBAdapter.NAMES[CommentsDBAdapter.PLATE_COMMENT_COL] = "Plate";
        CommentsDBAdapter.NAMES[CommentsDBAdapter.REPEATABLE_COMMENT_COL] = "Repeatable";
        COMMENTS_SCHEMA = new Schema(1, "Address", new Field[]{StringField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE}, NAMES);
    }
}

