/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;

public interface ArrayStringable
extends DataType {
    public boolean hasStringValue(Settings var1);

    default public String getArrayString(MemBuffer buf, Settings settings, int length) {
        if (this.hasStringValue(settings) && buf.isInitializedMemory()) {
            return new StringDataInstance(this, settings, buf, length, true).getStringValue();
        }
        return null;
    }

    public String getArrayDefaultLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4);

    public String getArrayDefaultOffcutLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4, int var5);

    public static ArrayStringable getArrayStringable(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt instanceof ArrayStringable ? (ArrayStringable)dt : null;
    }
}

