/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.database.DBStringMapAdapter;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.Objects;

public class BitFieldPackingImpl
implements BitFieldPacking {
    public static final boolean DEFAULT_USE_MS_CONVENTION = false;
    public static final boolean DEFAULT_TYPE_ALIGNMENT_ENABLED = true;
    public static final int DEFAULT_ZERO_LENGTH_BOUNDARY = 0;
    private boolean useMSConvention = false;
    private boolean typeAlignmentEnabled = true;
    private int zeroLengthBoundary = 0;

    @Override
    public boolean useMSConvention() {
        return this.useMSConvention;
    }

    @Override
    public boolean isTypeAlignmentEnabled() {
        return this.useMSConvention || this.typeAlignmentEnabled;
    }

    @Override
    public int getZeroLengthBoundary() {
        return this.useMSConvention ? 0 : this.zeroLengthBoundary;
    }

    public void setUseMSConvention(boolean useMSConvention) {
        this.useMSConvention = useMSConvention;
    }

    public void setTypeAlignmentEnabled(boolean typeAlignmentEnabled) {
        this.typeAlignmentEnabled = typeAlignmentEnabled;
    }

    public void setZeroLengthBoundary(int zeroLengthBoundary) {
        this.zeroLengthBoundary = zeroLengthBoundary;
    }

    static void save(BitFieldPacking bitfieldPacking, DBStringMapAdapter dataMap, String keyPrefix) throws IOException {
        int zeroLengthBoundary;
        boolean typeAlignmentEnabled;
        boolean useMSConvention = bitfieldPacking.useMSConvention();
        if (useMSConvention) {
            dataMap.put(keyPrefix + "use_MS_convention", Boolean.toString(useMSConvention));
        }
        if (!(typeAlignmentEnabled = bitfieldPacking.isTypeAlignmentEnabled())) {
            dataMap.put(keyPrefix + "type_alignment_enabled", Boolean.toString(typeAlignmentEnabled));
        }
        if ((zeroLengthBoundary = bitfieldPacking.getZeroLengthBoundary()) != 0) {
            dataMap.put(keyPrefix + "zero_length_boundary", Integer.toString(zeroLengthBoundary));
        }
    }

    static BitFieldPackingImpl restore(DBStringMapAdapter dataMap, String keyPrefix) throws IOException {
        BitFieldPackingImpl bitFieldPacking = new BitFieldPackingImpl();
        bitFieldPacking.useMSConvention = dataMap.getBoolean(keyPrefix + ElementId.ELEM_USE_MS_CONVENTION.name(), bitFieldPacking.useMSConvention);
        bitFieldPacking.typeAlignmentEnabled = dataMap.getBoolean(keyPrefix + ElementId.ELEM_TYPE_ALIGNMENT_ENABLED.name(), bitFieldPacking.typeAlignmentEnabled);
        bitFieldPacking.zeroLengthBoundary = dataMap.getInt(keyPrefix + ElementId.ELEM_ZERO_LENGTH_BOUNDARY.name(), bitFieldPacking.zeroLengthBoundary);
        return bitFieldPacking;
    }

    public void encode(Encoder encoder) throws IOException {
        if (!this.useMSConvention && this.typeAlignmentEnabled && this.zeroLengthBoundary == 0) {
            return;
        }
        encoder.openElement(ElementId.ELEM_BITFIELD_PACKING);
        if (this.useMSConvention) {
            encoder.openElement(ElementId.ELEM_USE_MS_CONVENTION);
            encoder.writeBool(AttributeId.ATTRIB_VALUE, true);
            encoder.closeElement(ElementId.ELEM_USE_MS_CONVENTION);
        }
        if (!this.typeAlignmentEnabled) {
            encoder.openElement(ElementId.ELEM_TYPE_ALIGNMENT_ENABLED);
            encoder.writeBool(AttributeId.ATTRIB_VALUE, false);
            encoder.closeElement(ElementId.ELEM_TYPE_ALIGNMENT_ENABLED);
        }
        if (this.zeroLengthBoundary != 0) {
            encoder.openElement(ElementId.ELEM_ZERO_LENGTH_BOUNDARY);
            encoder.writeSignedInteger(AttributeId.ATTRIB_VALUE, this.zeroLengthBoundary);
            encoder.closeElement(ElementId.ELEM_ZERO_LENGTH_BOUNDARY);
        }
        encoder.closeElement(ElementId.ELEM_BITFIELD_PACKING);
    }

    protected void restoreXml(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            String value = subel.getAttribute("value");
            if (name.equals(ElementId.ELEM_USE_MS_CONVENTION.name())) {
                this.useMSConvention = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals(ElementId.ELEM_TYPE_ALIGNMENT_ENABLED.name())) {
                this.typeAlignmentEnabled = SpecXmlUtils.decodeBoolean((String)value);
            } else if (name.equals(ElementId.ELEM_ZERO_LENGTH_BOUNDARY.name())) {
                this.zeroLengthBoundary = SpecXmlUtils.decodeInt((String)value);
            }
            parser.end(subel);
        }
        parser.end();
    }

    public int hashCode() {
        return Objects.hash(this.typeAlignmentEnabled, this.useMSConvention, this.zeroLengthBoundary);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitFieldPackingImpl other = (BitFieldPackingImpl)obj;
        return this.typeAlignmentEnabled == other.typeAlignmentEnabled && this.useMSConvention == other.useMSConvention && this.zeroLengthBoundary == other.zeroLengthBoundary;
    }
}

