/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LEB128 {
    public static final int MAX_SUPPORTED_LENGTH = 10;

    public static long unsigned(InputStream is) throws IOException {
        return LEB128.read(is, false);
    }

    public static long signed(InputStream is) throws IOException {
        return LEB128.read(is, true);
    }

    public static long read(InputStream is, boolean isSigned) throws IOException {
        int nextByte = 0;
        int shift = 0;
        long value = 0L;
        do {
            if ((nextByte = is.read()) < 0) {
                throw new EOFException();
            }
            if (shift == 70 || !isSigned && shift == 63 && nextByte > 1) {
                throw new IOException("Unsupported LEB128 value, too large to fit in 64bit java long variable");
            }
            value |= (long)(nextByte & 0x7F) << shift;
            shift += 7;
        } while ((nextByte & 0x80) != 0);
        if (isSigned && shift < 64 && (nextByte & 0x40) != 0) {
            value |= -1L << shift;
        }
        return value;
    }

    public static int getLength(InputStream is) throws IOException {
        int nextByte;
        for (int length = 0; (nextByte = is.read()) >= 0 && length < 10; ++length) {
            if ((nextByte & 0x80) != 0) continue;
            return length;
        }
        return -1;
    }

    public static long decode(byte[] bytes, int offset, boolean isSigned) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, offset, bytes.length - offset);
        return LEB128.read(is, isSigned);
    }
}

