/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class ConsumeExtra
extends AssignAction {
    private StorageClass resourceType;
    private boolean matchSize;
    private ParamEntry[] tiles;

    private void initializeEntries() throws InvalidInputException {
        this.tiles = this.resource.extractTiles(this.resourceType);
        if (this.tiles.length == 0) {
            throw new InvalidInputException("Could not find matching resources for action: consume_extra");
        }
    }

    protected ConsumeExtra(ParamListStandard res) {
        super(res);
        this.resourceType = StorageClass.GENERAL;
        this.matchSize = true;
    }

    public ConsumeExtra(StorageClass store, boolean match, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.resourceType = store;
        this.matchSize = match;
        this.initializeEntries();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new ConsumeExtra(this.resourceType, this.matchSize, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        ConsumeExtra otherAction = (ConsumeExtra)op;
        if (this.matchSize != otherAction.matchSize || this.resourceType != otherAction.resourceType) {
            return false;
        }
        if (this.tiles.length != otherAction.tiles.length) {
            return false;
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i].isEquivalent(otherAction.tiles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int sizeLeft = dt.getLength();
        for (int iter = 0; sizeLeft > 0 && iter != this.tiles.length; ++iter) {
            ParamEntry entry = this.tiles[iter];
            if (status[entry.getGroup()] != 0) continue;
            status[entry.getGroup()] = -1;
            sizeLeft -= entry.getSize();
            if (this.matchSize) continue;
            break;
        }
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CONSUME_EXTRA);
        encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        encoder.closeElement(ElementId.ELEM_CONSUME_EXTRA);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_CONSUME_EXTRA.name()});
        this.resourceType = StorageClass.getClass(elem.getAttribute(AttributeId.ATTRIB_STORAGE.name()));
        parser.end(elem);
        try {
            this.initializeEntries();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

