/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import java.util.ArrayList;

public class PrimitiveExtractor {
    private ArrayList<Primitive> primitives = new ArrayList();
    private boolean valid = true;
    private boolean aligned = true;
    private boolean unknownElements = false;
    private boolean extraSpace = false;
    private boolean unionInvalid;

    private int checkOverlap(ArrayList<Primitive> res, ArrayList<Primitive> small, int point, Primitive big) {
        int curOff;
        boolean useSmall;
        int endOff = big.offset + big.dt.getAlignedLength();
        boolean bl = useSmall = PcodeDataTypeManager.getMetatype(big.dt) == 7;
        while (point < small.size() && (curOff = small.get((int)point).offset) < endOff) {
            if ((curOff += small.get((int)point).dt.getAlignedLength()) > endOff) {
                return -1;
            }
            if (useSmall) {
                res.add(small.get(point));
            }
            ++point;
        }
        if (!useSmall) {
            res.add(big);
        }
        return point;
    }

    private boolean commonRefinement(ArrayList<Primitive> first, ArrayList<Primitive> second) {
        int firstPoint = 0;
        int secondPoint = 0;
        ArrayList<Primitive> common = new ArrayList<Primitive>();
        while (firstPoint < first.size() && secondPoint < second.size()) {
            Primitive firstElement = first.get(firstPoint);
            Primitive secondElement = second.get(secondPoint);
            if (firstElement.offset < secondElement.offset && firstElement.offset + firstElement.dt.getAlignedLength() <= secondElement.offset) {
                common.add(firstElement);
                ++firstPoint;
                continue;
            }
            if (secondElement.offset < firstElement.offset && secondElement.offset + secondElement.dt.getAlignedLength() <= firstElement.offset) {
                common.add(secondElement);
                ++secondPoint;
                continue;
            }
            if (firstElement.dt.getAlignedLength() >= secondElement.dt.getAlignedLength()) {
                if ((secondPoint = this.checkOverlap(common, second, secondPoint, firstElement)) < 0) {
                    return false;
                }
                ++firstPoint;
                continue;
            }
            if ((firstPoint = this.checkOverlap(common, first, firstPoint, secondElement)) < 0) {
                return false;
            }
            ++secondPoint;
        }
        while (firstPoint < first.size()) {
            common.add(first.get(firstPoint));
            ++firstPoint;
        }
        while (secondPoint < second.size()) {
            common.add(second.get(secondPoint));
            ++secondPoint;
        }
        first.clear();
        first.addAll(common);
        return true;
    }

    private boolean handleUnion(Union dt, int max, int offset) {
        int i;
        if (this.unionInvalid) {
            return false;
        }
        int num = dt.getNumComponents();
        if (num == 0) {
            return false;
        }
        DataTypeComponent curField = dt.getComponent(0);
        PrimitiveExtractor common = new PrimitiveExtractor(curField.getDataType(), false, offset + curField.getOffset(), max);
        if (!common.isValid()) {
            return false;
        }
        for (i = 1; i < num; ++i) {
            curField = dt.getComponent(i);
            PrimitiveExtractor next = new PrimitiveExtractor(curField.getDataType(), false, offset + curField.getOffset(), max);
            if (!next.isValid()) {
                return false;
            }
            if (this.commonRefinement(common.primitives, next.primitives)) continue;
            return false;
        }
        if (this.primitives.size() + common.primitives.size() > max) {
            return false;
        }
        for (i = 0; i < common.primitives.size(); ++i) {
            this.primitives.add(common.primitives.get(i));
        }
        return true;
    }

    private boolean extract(DataType dt, int max, int offset) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        int metaType = PcodeDataTypeManager.getMetatype(dt);
        switch (metaType) {
            case 12: {
                this.unknownElements = true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.primitives.size() >= max) {
                    return false;
                }
                this.primitives.add(new Primitive(dt, offset));
                return true;
            }
            case 4: {
                int numEls = ((Array)dt).getNumElements();
                DataType base = ((Array)dt).getDataType();
                for (int i = 0; i < numEls; ++i) {
                    if (!this.extract(base, max, offset)) {
                        return false;
                    }
                    offset += base.getAlignedLength();
                }
                return true;
            }
            case 2: {
                return this.handleUnion((Union)dt, max, offset);
            }
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        Structure structPtr = (Structure)dt;
        boolean isPacked = structPtr.isPackingEnabled();
        DataTypeComponent[] components = structPtr.getDefinedComponents();
        int expectedOff = offset;
        for (DataTypeComponent component : components) {
            DataType compDT = component.getDataType();
            int curOff = component.getOffset() + offset;
            if (!isPacked) {
                int rem;
                int align = compDT.getAlignment();
                if (curOff % align != 0) {
                    this.aligned = false;
                }
                if ((rem = expectedOff % align) != 0) {
                    expectedOff += align - rem;
                }
                if (expectedOff != curOff) {
                    this.extraSpace = true;
                }
            }
            if (!this.extract(compDT, max, curOff)) {
                return false;
            }
            expectedOff = curOff + compDT.getAlignedLength();
        }
        return true;
    }

    public PrimitiveExtractor(DataType dt, boolean unionIllegal, int offset, int max) {
        this.unionInvalid = unionIllegal;
        if (!this.extract(dt, max, offset)) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean containsUnknown() {
        return this.unknownElements;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public boolean containsHoles() {
        return this.extraSpace;
    }

    public int size() {
        return this.primitives.size();
    }

    public Primitive get(int i) {
        return this.primitives.get(i);
    }

    public static class Primitive {
        public DataType dt;
        public int offset;

        public Primitive(DataType d, int off) {
            this.dt = d;
            this.offset = off;
        }
    }
}

