/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockCopy;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeBlock;
import java.io.IOException;
import java.util.ArrayList;

public class BlockGraph
extends PcodeBlock {
    private ArrayList<PcodeBlock> list;
    private int maxindex;

    public BlockGraph() {
        this.blocktype = 2;
        this.list = new ArrayList();
        this.maxindex = -1;
    }

    public void addBlock(PcodeBlock bl) {
        int max;
        int min;
        if (bl instanceof BlockGraph) {
            BlockGraph gbl = (BlockGraph)bl;
            min = gbl.index;
            max = gbl.maxindex;
        } else {
            max = min = bl.index;
        }
        if (this.list.isEmpty()) {
            this.index = min;
            this.maxindex = max;
        } else {
            if (min < this.index) {
                this.index = min;
            }
            if (max > this.maxindex) {
                this.maxindex = max;
            }
        }
        bl.parent = this;
        this.list.add(bl);
    }

    public void setIndices() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get((int)i).index = i;
        }
        this.index = 0;
        this.maxindex = this.list.size() - 1;
    }

    public int getSize() {
        return this.list.size();
    }

    public PcodeBlock getBlock(int i) {
        return this.list.get(i);
    }

    public void addEdge(PcodeBlock begin, PcodeBlock end) {
        end.addInEdge(begin, 0);
    }

    public void transferObjectRef(BlockGraph ingraph) {
        ArrayList<BlockGraph> queue = new ArrayList<BlockGraph>();
        int pos = 0;
        queue.add(this);
        while (pos < queue.size()) {
            BlockGraph curgraph = (BlockGraph)queue.get(pos);
            ++pos;
            int sz = curgraph.getSize();
            for (int i = 0; i < sz; ++i) {
                PcodeBlock block = curgraph.getBlock(i);
                if (block instanceof BlockCopy) {
                    PcodeBlock block2;
                    BlockCopy copyblock = (BlockCopy)block;
                    int altindex = copyblock.getAltIndex();
                    if (altindex >= ingraph.getSize() || !((block2 = ingraph.getBlock(altindex)) instanceof BlockCopy)) continue;
                    BlockCopy copyblock2 = (BlockCopy)block2;
                    copyblock.set(copyblock2.getRef(), copyblock2.getStart());
                    continue;
                }
                if (!(block instanceof BlockGraph)) continue;
                queue.add((BlockGraph)block);
            }
        }
    }

    @Override
    protected void encodeBody(Encoder encoder) throws IOException {
        super.encodeBody(encoder);
        for (PcodeBlock bl : this.list) {
            encoder.openElement(ElementId.ELEM_BHEAD);
            encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, bl.getIndex());
            String name = PcodeBlock.typeToName(bl.blocktype);
            encoder.writeString(AttributeId.ATTRIB_TYPE, name);
            encoder.closeElement(ElementId.ELEM_BHEAD);
        }
        for (PcodeBlock bl : this.list) {
            bl.encode(encoder);
        }
    }

    @Override
    protected void decodeBody(Decoder decoder, BlockMap resolver) throws DecoderException {
        int el;
        BlockMap newresolver = new BlockMap(resolver);
        super.decodeBody(decoder, newresolver);
        ArrayList<PcodeBlock> tmplist = new ArrayList<PcodeBlock>();
        while ((el = decoder.peekElement()) == ElementId.ELEM_BHEAD.id()) {
            decoder.openElement();
            int ind = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
            String name = decoder.readString(AttributeId.ATTRIB_TYPE);
            PcodeBlock newbl = newresolver.createBlock(name, ind);
            tmplist.add(newbl);
            decoder.closeElement(el);
        }
        newresolver.sortLevelList();
        for (PcodeBlock bl : tmplist) {
            bl.decode(decoder, newresolver);
            this.addBlock(bl);
        }
    }

    public void decode(Decoder decoder) throws DecoderException {
        BlockMap resolver = new BlockMap(decoder.getAddressFactory());
        this.decode(decoder, resolver);
        resolver.resolveGotoReferences();
    }
}

