/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;

public class HighGlobal
extends HighVariable {
    private HighSymbol symbol;

    public HighGlobal(HighFunction high) {
        super(high);
    }

    public HighGlobal(HighSymbol sym, Varnode vn, Varnode[] inst) {
        super(sym.getName(), sym.getDataType(), vn, inst, sym.getHighFunction());
        this.symbol = sym;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int attribId;
        long symref = 0L;
        this.offset = -1;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_OFFSET.id()) {
                this.offset = (int)decoder.readSignedInteger();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_SYMREF.id()) continue;
            symref = decoder.readUnsignedInteger();
        }
        this.decodeInstances(decoder);
        if (symref != 0L) {
            this.symbol = this.function.getGlobalSymbolMap().getSymbol(symref);
        } else {
            Msg.warn((Object)this, (Object)"Missing symref attribute in <high> tag");
        }
        if (this.symbol == null) {
            int symbolSize;
            DataType symbolType;
            if (this.offset < 0) {
                symbolType = this.type;
                symbolSize = this.getSize();
            } else {
                symbolType = null;
                symbolSize = -1;
            }
            GlobalSymbolMap globalMap = this.function.getGlobalSymbolMap();
            this.symbol = globalMap.populateSymbol(symref, symbolType, symbolSize);
            if (this.symbol == null) {
                Address addr = this.represent.getAddress();
                if (this.offset > 0) {
                    addr = addr.subtract(this.offset);
                }
                this.symbol = globalMap.newSymbol(symref, addr, symbolType, symbolSize);
                if (this.symbol == null) {
                    throw new DecoderException("Bad global storage: " + addr.toString());
                }
            }
        }
        if (this.offset < 0) {
            this.name = this.symbol.getName();
        }
        this.symbol.setHighVariable(this);
    }
}

