/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager.breakpoint;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum JdiBreakpointType {
    BREAKPOINT("breakpoint", false),
    ACCESS_WATCHPOINT("access watchpont", true),
    MODIFICATION_WATCHPOINT("modification watchpoint", true),
    OTHER("<OTHER>", false);

    public static final Map<String, JdiBreakpointType> BY_NAME;
    private final String name;
    private final boolean isWatchpoint;

    public static JdiBreakpointType fromStr(String string) {
        return BY_NAME.getOrDefault(string, OTHER);
    }

    private JdiBreakpointType(String name, boolean isWatchpoint) {
        this.name = name;
        this.isWatchpoint = isWatchpoint;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWatchpoint() {
        return this.isWatchpoint;
    }

    static {
        BY_NAME = List.of(JdiBreakpointType.values()).stream().collect(Collectors.toMap(v -> v.getName(), v -> v));
    }
}

