/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DialogComponentProvider;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GIconLabel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckoutDialog
extends DialogComponentProvider {
    public static final int OK = 0;
    public static final int CANCELED = 1;
    private JCheckBox exclusiveCB;
    private int actionID = 1;

    public CheckoutDialog() {
        super("Checkout Versioned File(s)");
        this.setHelpLocation(new HelpLocation("Repository", "CheckoutDialog"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    protected void okCallback() {
        this.actionID = 0;
        this.close();
    }

    protected void cancelCallback() {
        this.actionID = 1;
        this.close();
    }

    public int showDialog(PluginTool tool) {
        this.exclusiveCB.setSelected(false);
        tool.showDialog(this);
        return this.actionID;
    }

    public boolean exclusiveCheckout() {
        return this.exclusiveCB.isSelected();
    }

    private JPanel buildMainPanel() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        innerPanel.getAccessibleContext().setAccessibleName("File Checkout");
        JPanel msgPanel = new JPanel(new BorderLayout());
        msgPanel.add((Component)new GIconLabel(OptionDialog.getIconForMessageType((int)3)), "West");
        MultiLineLabel msgText = new MultiLineLabel("Checkout selected file(s)?");
        msgText.setMaximumSize(msgText.getPreferredSize());
        msgPanel.add((Component)msgText, "Center");
        msgPanel.getAccessibleContext().setAccessibleName("Message");
        innerPanel.add((Component)msgPanel, "Center");
        this.exclusiveCB = new GCheckBox("Request exclusive checkout");
        this.exclusiveCB.getAccessibleContext().setAccessibleName("Exclusive Checkout Box");
        JPanel cbPanel = new JPanel(new BorderLayout());
        cbPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        cbPanel.add(this.exclusiveCB);
        cbPanel.getAccessibleContext().setAccessibleName("Options");
        innerPanel.add((Component)cbPanel, "South");
        return innerPanel;
    }
}

