/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import generic.ULongSpan;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.AbstractBytesPcodeExecutorStatePiece;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.BytesPcodeExecutorStateSpace;
import ghidra.pcode.exec.trace.TracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.util.MathUtilities;
import java.nio.ByteBuffer;
import java.util.Map;

public class BytesTracePcodeExecutorStatePiece
extends AbstractBytesPcodeExecutorStatePiece<CachedSpace>
implements TracePcodeExecutorStatePiece<byte[], byte[]> {
    protected final PcodeTraceDataAccess data;

    public BytesTracePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        super(data.getLanguage());
        this.data = data;
    }

    protected BytesTracePcodeExecutorStatePiece(PcodeTraceDataAccess data, AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<CachedSpace> spaceMap) {
        super(data.getLanguage(), spaceMap);
        this.data = data;
    }

    @Override
    public PcodeTraceDataAccess getData() {
        return this.data;
    }

    @Override
    public BytesTracePcodeExecutorStatePiece fork() {
        return new BytesTracePcodeExecutorStatePiece(this.data, (AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<CachedSpace>)this.spaceMap.fork());
    }

    @Override
    public void writeDown(PcodeTraceDataAccess into) {
        if (into.getLanguage() != this.language) {
            throw new IllegalArgumentException("Destination platform must be same language as source");
        }
        for (CachedSpace cached : this.spaceMap.values()) {
            cached.writeDown(into);
        }
    }

    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<CachedSpace> newSpaceMap() {
        return new TraceBackedSpaceMap();
    }

    protected static class CachedSpace
    extends BytesPcodeExecutorStateSpace<PcodeTraceDataAccess> {
        protected final AddressSet written;

        public CachedSpace(Language language, AddressSpace space, PcodeTraceDataAccess backing) {
            super(language, space, (Object)backing);
            this.written = new AddressSet();
        }

        protected CachedSpace(Language language, AddressSpace space, PcodeTraceDataAccess backing, SemisparseByteArray bytes, AddressSet written) {
            super(language, space, (Object)backing, bytes);
            this.written = written;
        }

        public CachedSpace fork() {
            return new CachedSpace(this.language, this.space, (PcodeTraceDataAccess)this.backing, this.bytes.fork(), new AddressSet((AddressSetView)this.written));
        }

        public void write(long offset, byte[] val, int srcOffset, int length) {
            super.write(offset, val, srcOffset, length);
            Address loc = this.space.getAddress(offset);
            Address end = loc.addWrap((long)(length - 1));
            if (loc.compareTo((Object)end) <= 0) {
                this.written.add(loc, end);
            } else {
                this.written.add(loc, this.space.getMaxAddress());
                this.written.add(this.space.getMinAddress(), end);
            }
        }

        protected AddressSetView intersectViewKnown(AddressSetView set) {
            return ((PcodeTraceDataAccess)this.backing).intersectViewKnown(set, true);
        }

        protected ULongSpan.ULongSpanSet readUninitializedFromBacking(ULongSpan.ULongSpanSet uninitialized) {
            if (uninitialized.isEmpty()) {
                return uninitialized;
            }
            AddressSetView knownButUninit = this.intersectViewKnown((AddressSetView)this.addrSet(uninitialized));
            if (knownButUninit.isEmpty()) {
                return uninitialized;
            }
            AddressRangeImpl knownBound = new AddressRangeImpl(knownButUninit.getMinAddress(), knownButUninit.getMaxAddress());
            ByteBuffer buf = ByteBuffer.allocate((int)knownBound.getLength());
            ((PcodeTraceDataAccess)this.backing).getBytes(knownBound.getMinAddress(), buf);
            for (AddressRange range : knownButUninit) {
                this.bytes.putData(range.getMinAddress().getOffset(), buf.array(), (int)range.getMinAddress().subtract(knownBound.getMinAddress()), (int)range.getLength());
            }
            ULongSpan uninitBound = (ULongSpan)uninitialized.bound();
            return this.bytes.getUninitialized(((Long)uninitBound.min()).longValue(), ((Long)uninitBound.max()).longValue());
        }

        protected void warnUnknown(AddressSetView unknown) {
            this.warnAddressSet("Emulator state initialized from UNKNOWN", unknown);
        }

        protected void writeDown(PcodeTraceDataAccess into) {
            if (this.space.isUniqueSpace()) {
                return;
            }
            byte[] data = new byte[4096];
            ByteBuffer buf = ByteBuffer.wrap(data);
            for (AddressRange range : this.written) {
                int len;
                long lower = range.getMinAddress().getOffset();
                for (long fullLen = range.getLength(); fullLen > 0L; fullLen -= (long)len) {
                    len = MathUtilities.unsignedMin((int)data.length, (long)fullLen);
                    this.bytes.getData(lower, data, 0, len);
                    buf.position(0);
                    buf.limit(len);
                    into.putBytes(this.space.getAddress(lower), buf);
                    lower += (long)len;
                }
            }
        }
    }

    protected class TraceBackedSpaceMap
    extends AbstractLongOffsetPcodeExecutorStatePiece.CacheingSpaceMap<PcodeTraceDataAccess, CachedSpace> {
        public TraceBackedSpaceMap() {
        }

        protected TraceBackedSpaceMap(Map<AddressSpace, CachedSpace> spaces) {
            super(spaces);
        }

        protected PcodeTraceDataAccess getBacking(AddressSpace space) {
            return BytesTracePcodeExecutorStatePiece.this.data;
        }

        protected CachedSpace newSpace(AddressSpace space, PcodeTraceDataAccess backing) {
            return new CachedSpace(BytesTracePcodeExecutorStatePiece.this.language, space, backing);
        }

        public TraceBackedSpaceMap fork() {
            return new TraceBackedSpaceMap(this.fork(this.spaces));
        }

        public CachedSpace fork(CachedSpace s) {
            return s.fork();
        }
    }
}

