/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.util.LockHold;
import ghidra.util.Saveable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NoValueException;
import ghidra.util.map.TypeMismatchException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class DBTraceProgramViewPropertyMapManager
implements PropertyMapManager {
    protected final DBTraceProgramView program;

    public DBTraceProgramViewPropertyMapManager(DBTraceProgramView program) {
        this.program = program;
    }

    public IntPropertyMap createIntPropertyMap(String propertyName) throws DuplicateNameException {
        return new DBTraceProgramViewIntPropertyMap(this.program.trace.getAddressPropertyManager().createPropertyMap(propertyName, Integer.class), propertyName);
    }

    public LongPropertyMap createLongPropertyMap(String propertyName) throws DuplicateNameException {
        return new DBTraceProgramViewLongPropertyMap(this.program.trace.getAddressPropertyManager().createPropertyMap(propertyName, Long.class), propertyName);
    }

    public StringPropertyMap createStringPropertyMap(String propertyName) throws DuplicateNameException {
        return new DBTraceProgramViewStringPropertyMap(this.program.trace.getAddressPropertyManager().createPropertyMap(propertyName, String.class), propertyName);
    }

    public <T extends Saveable> ObjectPropertyMap<T> createObjectPropertyMap(String propertyName, Class<T> objectClass) throws DuplicateNameException {
        return new DBTraceProgramViewObjectPropertyMap<T>(this.program.trace.getAddressPropertyManager().createPropertyMap(propertyName, objectClass), propertyName);
    }

    public VoidPropertyMap createVoidPropertyMap(String propertyName) throws DuplicateNameException {
        return new DBTraceProgramViewVoidPropertyMap(this.program.trace.getAddressPropertyManager().createPropertyMap(propertyName, Boolean.class), propertyName);
    }

    public PropertyMap<?> getPropertyMap(String propertyName) {
        TracePropertyMap<Integer> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName);
        if (map == null) {
            return null;
        }
        Class cls = map.getValueClass();
        if (cls == Integer.class) {
            return new DBTraceProgramViewIntPropertyMap(map, propertyName);
        }
        if (cls == Long.class) {
            return new DBTraceProgramViewLongPropertyMap((TracePropertyMap<Long>)map, propertyName);
        }
        if (cls == String.class) {
            return new DBTraceProgramViewStringPropertyMap((TracePropertyMap<String>)map, propertyName);
        }
        if (cls == Void.class) {
            return new DBTraceProgramViewVoidPropertyMap((TracePropertyMap<Boolean>)map, propertyName);
        }
        if (Saveable.class.isAssignableFrom(cls)) {
            return new DBTraceProgramViewObjectPropertyMap<Integer>(map, propertyName);
        }
        throw new AssertionError((Object)("Where did this property map type come from? " + String.valueOf(cls)));
    }

    public IntPropertyMap getIntPropertyMap(String propertyName) {
        TracePropertyMap<Integer> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName, Integer.class);
        return map == null ? null : new DBTraceProgramViewIntPropertyMap(map, propertyName);
    }

    public LongPropertyMap getLongPropertyMap(String propertyName) {
        TracePropertyMap<Long> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName, Long.class);
        return map == null ? null : new DBTraceProgramViewLongPropertyMap(map, propertyName);
    }

    public StringPropertyMap getStringPropertyMap(String propertyName) {
        TracePropertyMap<String> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName, String.class);
        return map == null ? null : new DBTraceProgramViewStringPropertyMap(map, propertyName);
    }

    public ObjectPropertyMap<? extends Saveable> getObjectPropertyMap(String propertyName) {
        TracePropertyMap<?> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName);
        if (map == null) {
            return null;
        }
        if (!Saveable.class.isAssignableFrom(map.getValueClass())) {
            throw new TypeMismatchException("Property " + propertyName + " is not object type");
        }
        return new DBTraceProgramViewObjectPropertyMap(map, propertyName);
    }

    public VoidPropertyMap getVoidPropertyMap(String propertyName) {
        TracePropertyMap<Boolean> map = this.program.trace.getAddressPropertyManager().getPropertyMap(propertyName, Boolean.class);
        return map == null ? null : new DBTraceProgramViewVoidPropertyMap(map, propertyName);
    }

    public boolean removePropertyMap(String propertyName) {
        throw new UnsupportedOperationException();
    }

    public Iterator<String> propertyManagers() {
        return this.program.trace.getAddressPropertyManager().getAllProperties().keySet().iterator();
    }

    protected void removeAll(Lifespan span, AddressRange range) {
        try (LockHold hold = this.program.trace.lockWrite();){
            for (TracePropertyMap<?> map : this.program.trace.getAddressPropertyManager().getAllProperties().values()) {
                map.clear(span, range);
            }
        }
    }

    public void removeAll(Address addr) {
        this.removeAll(Lifespan.nowOnMaybeScratch(this.program.snap), (AddressRange)new AddressRangeImpl(addr, addr));
    }

    public void removeAll(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.removeAll(Lifespan.nowOnMaybeScratch(this.program.snap), (AddressRange)new AddressRangeImpl(startAddr, endAddr));
    }

    protected class DBTraceProgramViewIntPropertyMap
    extends AbstractDBTraceProgramViewPropertyMap<Integer>
    implements IntPropertyMap {
        public DBTraceProgramViewIntPropertyMap(TracePropertyMap<Integer> map, String name) {
            super(map, name);
        }

        public void add(Address addr, int value) {
            this.map.set(Lifespan.nowOnMaybeScratch(DBTraceProgramViewPropertyMapManager.this.program.snap), addr, Integer.valueOf(value));
        }

        public int getInt(Address addr) throws NoValueException {
            Integer value = (Integer)this.get(addr);
            if (value == null) {
                throw new NoValueException();
            }
            return value;
        }
    }

    protected class DBTraceProgramViewLongPropertyMap
    extends AbstractDBTraceProgramViewPropertyMap<Long>
    implements LongPropertyMap {
        public DBTraceProgramViewLongPropertyMap(TracePropertyMap<Long> map, String name) {
            super(map, name);
        }

        public void add(Address addr, long value) {
            this.map.set(Lifespan.nowOnMaybeScratch(DBTraceProgramViewPropertyMapManager.this.program.snap), addr, Long.valueOf(value));
        }

        public long getLong(Address addr) throws NoValueException {
            Long value = (Long)this.get(addr);
            if (value == null) {
                throw new NoValueException();
            }
            return value;
        }
    }

    protected class DBTraceProgramViewStringPropertyMap
    extends AbstractDBTraceProgramViewPropertyMap<String>
    implements StringPropertyMap {
        public DBTraceProgramViewStringPropertyMap(TracePropertyMap<String> map, String name) {
            super(map, name);
        }

        public void add(Address addr, String value) {
            this.map.set(Lifespan.nowOnMaybeScratch(DBTraceProgramViewPropertyMapManager.this.program.snap), addr, value);
        }

        public String getString(Address addr) {
            return (String)this.get(addr);
        }
    }

    protected class DBTraceProgramViewObjectPropertyMap<T extends Saveable>
    extends AbstractDBTraceProgramViewPropertyMap<T>
    implements ObjectPropertyMap<T> {
        public DBTraceProgramViewObjectPropertyMap(TracePropertyMap<T> map, String name) {
            super(map, name);
        }

        public void add(Address addr, Saveable value) {
            this.map.set(Lifespan.nowOnMaybeScratch(DBTraceProgramViewPropertyMapManager.this.program.snap), addr, (Saveable)this.map.getValueClass().cast(value));
        }

        public Class<T> getValueClass() {
            return this.map.getValueClass();
        }
    }

    protected class DBTraceProgramViewVoidPropertyMap
    extends AbstractDBTraceProgramViewPropertyMap<Boolean>
    implements VoidPropertyMap {
        public DBTraceProgramViewVoidPropertyMap(TracePropertyMap<Boolean> map, String name) {
            super(map, name);
        }

        public void add(Address addr) {
            this.map.set(Lifespan.nowOnMaybeScratch(DBTraceProgramViewPropertyMapManager.this.program.snap), addr, Boolean.valueOf(true));
        }
    }

    protected abstract class AbstractDBTraceProgramViewPropertyMap<T>
    implements PropertyMap<T> {
        protected final TracePropertyMap<T> map;
        protected final String name;

        public AbstractDBTraceProgramViewPropertyMap(TracePropertyMap<T> map, String name) {
            this.map = map;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        protected AddressSetView getAddressSetView() {
            return this.map.getAddressSetView(Lifespan.at(DBTraceProgramViewPropertyMapManager.this.program.snap));
        }

        public boolean intersects(Address start, Address end) {
            return this.getAddressSetView().intersects(start, end);
        }

        public boolean intersects(AddressSetView set) {
            return this.getAddressSetView().intersects(set);
        }

        public boolean removeRange(Address start, Address end) {
            return this.map.clear(Lifespan.at(DBTraceProgramViewPropertyMapManager.this.program.snap), (AddressRange)new AddressRangeImpl(start, end));
        }

        public boolean remove(Address addr) {
            return this.removeRange(addr, addr);
        }

        public boolean hasProperty(Address addr) {
            return this.intersects(addr, addr);
        }

        public T get(Address addr) {
            return this.map.get(DBTraceProgramViewPropertyMapManager.this.program.snap, addr);
        }

        public Address getNextPropertyAddress(Address addr) {
            Address next = addr.next();
            if (next == null) {
                return null;
            }
            AddressRangeIterator it = this.getAddressSetView().getAddressRanges(next, true);
            if (!it.hasNext()) {
                return null;
            }
            AddressRange range = (AddressRange)it.next();
            if (!range.contains(next)) {
                return next;
            }
            return range.getMinAddress();
        }

        public Address getPreviousPropertyAddress(Address addr) {
            Address prev = addr.previous();
            if (prev == null) {
                return null;
            }
            AddressRangeIterator it = this.getAddressSetView().getAddressRanges(prev, false);
            if (!it.hasNext()) {
                return null;
            }
            AddressRange range = (AddressRange)it.next();
            if (!range.contains(prev)) {
                return prev;
            }
            return range.getMaxAddress();
        }

        public Address getFirstPropertyAddress() {
            return this.getAddressSetView().getMinAddress();
        }

        public Address getLastPropertyAddress() {
            return this.getAddressSetView().getMaxAddress();
        }

        public int getSize() {
            return (int)this.getAddressSetView().getNumAddresses();
        }

        public AddressIterator getPropertyIterator(Address start, Address end) {
            return this.getPropertyIterator(start, end, true);
        }

        public AddressIterator getPropertyIterator(Address start, Address end, boolean forward) {
            return this.getAddressSetView().intersectRange(start, end).getAddresses(forward);
        }

        public AddressIterator getPropertyIterator() {
            return this.getAddressSetView().getAddresses(true);
        }

        public AddressIterator getPropertyIterator(AddressSetView asv) {
            return this.getPropertyIterator(asv, true);
        }

        public AddressIterator getPropertyIterator(AddressSetView asv, boolean forward) {
            return this.getAddressSetView().intersect(asv).getAddresses(forward);
        }

        public AddressIterator getPropertyIterator(Address start, boolean forward) {
            return this.getAddressSetView().getAddresses(start, forward);
        }

        public void moveRange(Address start, Address end, Address newStart) {
            throw new UnsupportedOperationException();
        }
    }
}

