/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.database.program.AbstractDBTraceProgramViewListing;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.program.TraceProgramViewRegisterListing;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DBTraceProgramViewRegisterListing
extends AbstractDBTraceProgramViewListing
implements TraceProgramViewRegisterListing {
    private final TraceThread thread;
    private Address minAddr;
    private Address maxAddr;

    public DBTraceProgramViewRegisterListing(DBTraceProgramView program, DBTraceCodeSpace regSpace) {
        super(program, regSpace);
        this.thread = regSpace.getThread();
        AddressSpace space = program.getAddressFactory().getRegisterSpace();
        this.minAddr = space.getMinAddress();
        this.maxAddr = space.getMaxAddress();
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public UndefinedDBTraceData doCreateUndefinedUnit(Address address) {
        throw new UnsupportedOperationException();
    }

    public boolean isUndefined(Address start, Address end) {
        return this.codeOperations.undefinedData().coversRange(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(start, end));
    }

    public void clearCodeUnits(Address startAddr, Address endAddr, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        this.codeOperations.definedUnits().clear(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(startAddr, endAddr), clearContext, monitor);
    }

    public void clearAll(boolean clearContext, TaskMonitor monitor) {
        try {
            this.codeOperations.definedUnits().clear(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(this.minAddr, this.maxAddr), clearContext, monitor);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }
}

