/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.property;

import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.property.TracePropertyMapOperations;
import ghidra.trace.model.property.TracePropertyMapSpace;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;

public interface TracePropertyMap<T>
extends TracePropertyMapOperations<T> {
    public TracePropertyMapSpace<T> getPropertyMapSpace(AddressSpace var1, boolean var2);

    public TracePropertyMapSpace<T> getPropertyMapRegisterSpace(TraceThread var1, int var2, boolean var3);

    default public TracePropertyMapSpace<T> getPropertyMapRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return this.getPropertyMapRegisterSpace(frame.getStack().getThread(), frame.getLevel(), createIfAbsent);
    }

    default public TracePropertyMapSpace<T> getPropertyMapSpace(TraceAddressSpace traceSpace, boolean createIfAbsent) {
        if (traceSpace.getAddressSpace().isRegisterSpace()) {
            return this.getPropertyMapRegisterSpace(traceSpace.getThread(), traceSpace.getFrameLevel(), createIfAbsent);
        }
        return this.getPropertyMapSpace(traceSpace.getAddressSpace(), createIfAbsent);
    }

    public void delete();
}

