/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.features.codecompare.graphanalysis.CtrlGraph;
import ghidra.features.codecompare.graphanalysis.CtrlNGram;
import ghidra.features.codecompare.graphanalysis.Pinning;
import ghidra.program.model.pcode.PcodeBlockBasic;
import java.util.ArrayList;

public class CtrlVertex {
    private PcodeBlockBasic block;
    int uid;
    ArrayList<CtrlVertex> sources;
    ArrayList<CtrlVertex> sinks;
    ArrayList<CtrlNGram> ngrams;
    CtrlGraph graph;

    public CtrlVertex(PcodeBlockBasic blk, int id, CtrlGraph grph) {
        this.block = blk;
        this.uid = id * 2 + grph.side.getValue();
        this.sources = new ArrayList();
        this.sinks = new ArrayList();
        this.ngrams = new ArrayList();
        int hash = this.depthZeroHash(0);
        this.ngrams.add(new CtrlNGram(this, 1, 0, hash));
        this.graph = grph;
    }

    int depthZeroHash(int flavor) {
        int encoding = 1;
        encoding = Pinning.hashTwo(encoding, this.block.getInSize());
        encoding = Pinning.hashTwo(encoding, this.block.getOutSize());
        encoding = Pinning.hashTwo(encoding, flavor);
        return encoding;
    }

    void nextNGramSource(int index) {
        int nextSize = 1;
        int masterSourceHash = 0;
        for (CtrlVertex neighbor : this.sources) {
            CtrlNGram gram = neighbor.ngrams.get(index);
            masterSourceHash += gram.hash;
            nextSize += gram.weight;
        }
        int nextEntry = this.ngrams.get((int)0).hash;
        nextEntry = Pinning.hashTwo(nextEntry, masterSourceHash);
        this.ngrams.add(new CtrlNGram(this, nextSize, this.ngrams.get((int)index).depth + 1, nextEntry));
    }

    void nextNGramSink(int index) {
        int nextSize = 1;
        int masterSourceHash = 1027021;
        for (CtrlVertex neighbor : this.sinks) {
            CtrlNGram gram = neighbor.ngrams.get(index);
            masterSourceHash += gram.hash;
            nextSize += gram.weight;
        }
        int nextEntry = this.ngrams.get((int)0).hash;
        nextEntry = Pinning.hashTwo(nextEntry, masterSourceHash);
        this.ngrams.add(new CtrlNGram(this, nextSize, this.ngrams.get((int)index).depth + 1, nextEntry));
    }

    void addEdgeColor() {
        if (this.sources.size() == 1) {
            int edgeColor;
            CtrlNGram zeroGram = this.ngrams.get(0);
            CtrlVertex src = this.sources.get(0);
            for (edgeColor = 0; edgeColor < src.sinks.size() && src.sinks.get(edgeColor) != this; ++edgeColor) {
            }
            zeroGram.hash = Pinning.hashTwo(zeroGram.hash, edgeColor);
        }
    }

    public void clearNGrams() {
        while (this.ngrams.size() > 1) {
            this.ngrams.remove(this.ngrams.size() - 1);
        }
    }

    public void setZeroGram(int flavor) {
        int hash;
        this.ngrams.get((int)0).hash = hash = this.depthZeroHash(flavor);
    }

    public String toString() {
        String result = Integer.toString(this.uid);
        return result;
    }
}

