/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.plugin;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.FunctionSupplierContext;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.FunctionComparisonService;
import ghidra.features.base.codecompare.model.AnyToAnyFunctionComparisonModel;
import ghidra.features.base.codecompare.model.FunctionComparisonModel;
import ghidra.features.codecompare.plugin.FunctionComparisonProvider;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import utility.function.Callback;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Compare Functions", description="Allows users to compare two or more functions", servicesProvided={FunctionComparisonService.class}, eventsConsumed={ProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class})
public class FunctionComparisonPlugin
extends ProgramPlugin
implements DomainObjectListener,
FunctionComparisonService {
    private Set<FunctionComparisonProvider> providers = new HashSet<FunctionComparisonProvider>();
    private FunctionComparisonProvider lastActiveProvider;

    public FunctionComparisonPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    public void dispose() {
        this.foreEachProvider(p -> p.closeComponent());
    }

    protected void programOpened(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    protected void programClosed(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.foreEachProvider(p -> p.programClosed(program));
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        for (int i = 0; i < ev.numRecords(); ++i) {
            ProgramChangeRecord rec;
            Function function;
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            EventType eventType = doRecord.getEventType();
            if (eventType == DomainObjectEvent.RESTORED) {
                this.domainObjectRestored((Program)ev.getSource());
                continue;
            }
            if (eventType != ProgramEvent.FUNCTION_REMOVED || (function = (Function)(rec = (ProgramChangeRecord)ev.getChangeRecord(i)).getObject()) == null) continue;
            this.removeFunction(function);
        }
    }

    void providerClosed(FunctionComparisonProvider provider) {
        this.providers.remove((Object)provider);
        if (this.lastActiveProvider == provider) {
            this.lastActiveProvider = null;
        }
    }

    void removeFunction(Function function) {
        Swing.runIfSwingOrRunLater(() -> this.doRemoveFunction(function));
    }

    void providerActivated(FunctionComparisonProvider provider) {
        if (provider.supportsAddingFunctions()) {
            this.lastActiveProvider = provider;
        }
    }

    private void foreEachProvider(Consumer<FunctionComparisonProvider> c) {
        ArrayList<FunctionComparisonProvider> localCopy = new ArrayList<FunctionComparisonProvider>(this.providers);
        localCopy.forEach(c);
    }

    private void domainObjectRestored(Program program) {
        this.foreEachProvider(p -> p.programRestored(program));
    }

    private void createActions() {
        HelpLocation help = new HelpLocation("FunctionComparison", "Function_Comparison_Actions");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Function Comparison", this.getName()).popupMenuPath(new String[]{"Compare Function(s)"})).popupMenuGroup("Functions", "Z1")).description("Adds the selected function(s) to the current comparison window.")).helpLocation(help)).withContext(FunctionSupplierContext.class).enabledWhen(c -> !this.isListing((FunctionSupplierContext)c) && c.hasFunctions()).onAction(c -> this.addToComparison(c.getFunctions())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Function Comparison (Listing)", this.getName()).popupMenuPath(new String[]{"Function", "Compare Function(s)"})).popupMenuGroup("Functions", "Z1")).description("Adds the selected function(s) to the current comparison window.")).helpLocation(help)).withContext(FunctionSupplierContext.class).enabledWhen(c -> this.isListing((FunctionSupplierContext)c) && c.hasFunctions()).onAction(c -> this.addToComparison(c.getFunctions())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("New Function Comparison", this.getName()).popupMenuPath(new String[]{"Compare in New Window"})).popupMenuGroup("Functions", "Z2")).description("Compare the selected function(s) in a new comparison window.")).helpLocation(help)).withContext(FunctionSupplierContext.class).enabledWhen(c -> !this.isListing((FunctionSupplierContext)c) && c.hasFunctions() && this.hasExistingComparison()).onAction(c -> this.createComparison(c.getFunctions())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("New Function Comparison (Listing)", this.getName()).popupMenuPath(new String[]{"Function", "Compare in New Window"})).popupMenuGroup("Functions", "Z2")).description("Compare the selected function(s) in a new comparison window.")).helpLocation(help)).withContext(FunctionSupplierContext.class).enabledWhen(c -> this.isListing((FunctionSupplierContext)c) && c.hasFunctions() && this.hasExistingComparison()).onAction(c -> this.createComparison(c.getFunctions())).buildAndInstall((Tool)this.tool);
    }

    private boolean isListing(FunctionSupplierContext context) {
        return context instanceof ListingActionContext;
    }

    private boolean hasExistingComparison() {
        return this.lastActiveProvider != null;
    }

    private void doRemoveFunction(Function function) {
        this.foreEachProvider(p -> p.getModel().removeFunction(function));
    }

    private FunctionComparisonProvider createProvider(FunctionComparisonModel model) {
        return this.createProvider(model, null);
    }

    private FunctionComparisonProvider createProvider(FunctionComparisonModel model, Callback closeListener) {
        FunctionComparisonProvider provider = new FunctionComparisonProvider(this, model, closeListener);
        this.providers.add(provider);
        return provider;
    }

    public void createComparison(Collection<Function> functions) {
        if (functions.isEmpty()) {
            return;
        }
        AnyToAnyFunctionComparisonModel model = new AnyToAnyFunctionComparisonModel(functions);
        Swing.runLater(() -> this.createProvider((FunctionComparisonModel)model));
    }

    public void createComparison(Function left, Function right) {
        AnyToAnyFunctionComparisonModel model = new AnyToAnyFunctionComparisonModel(left, right);
        Swing.runLater(() -> this.createProvider((FunctionComparisonModel)model));
    }

    public void addToComparison(Collection<Function> functions) {
        if (this.lastActiveProvider == null) {
            this.createComparison(functions);
        } else {
            Swing.runLater(() -> this.lastActiveProvider.addFunctions(functions));
        }
    }

    public void addToComparison(Function function) {
        this.addToComparison(Arrays.asList(function));
    }

    public void createCustomComparison(FunctionComparisonModel model, Callback closeListener) {
        Swing.runLater(() -> this.createProvider(model, closeListener));
    }
}

