/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.graph.VisualGraph;
import ghidra.graph.job.AbstractAnimator;
import ghidra.graph.job.EdgeHoverAnimator;
import ghidra.graph.job.EnsureAreaVisibleAnimatorFunctionGraphJob;
import ghidra.graph.job.FitGraphToViewJob;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.GraphJobRunner;
import ghidra.graph.job.MoveVertexToCenterAnimatorFunctionGraphJob;
import ghidra.graph.job.MoveVertexToCenterTopAnimatorFunctionGraphJob;
import ghidra.graph.job.MoveViewToLayoutSpacePointAnimatorFunctionGraphJob;
import ghidra.graph.job.MoveViewToViewSpacePointAnimatorFunctionGraphJob;
import ghidra.graph.job.RelayoutFunctionGraphJob;
import ghidra.graph.job.TwinkleVertexAnimator;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.routing.BasicEdgeRouter;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.BusyListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Objects;
import utility.function.Callback;

public class VisualGraphViewUpdater<V extends VisualVertex, E extends VisualEdge<V>> {
    private VisualGraph<V, E> graph;
    private GraphJobRunner jobRunner = new GraphJobRunner();
    private static AbstractAnimator edgeHoverAnimator;
    private static TwinkleVertexAnimator<?, ?> vertexTwinkleAnimator;
    private GraphViewer<V, E> primaryViewer;
    private SatelliteGraphViewer<V, E> satelliteViewer;
    private WeakSet<Callback> jobStartedListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public VisualGraphViewUpdater(GraphViewer<V, E> primaryViewer, VisualGraph<V, E> graph) {
        this.primaryViewer = Objects.requireNonNull(primaryViewer);
        this.graph = Objects.requireNonNull(graph);
    }

    protected void setSatelliteViewer(SatelliteGraphViewer<V, E> satelliteViewer) {
        this.satelliteViewer = satelliteViewer;
    }

    public void addJobScheduledListener(Callback c) {
        this.jobStartedListeners.add((Object)c);
    }

    public boolean isAnimationEnabled() {
        return this.primaryViewer.getOptions().useAnimation();
    }

    public void dispose() {
        this.jobRunner.dispose();
    }

    public void fitAllGraphsToViewsNow() {
        this.scheduleViewChangeJob(new FitGraphToViewJob(new VisualizationServer[]{this.primaryViewer, this.satelliteViewer}));
    }

    public void fitGraphToViewerNow() {
        this.fitGraphToViewerNow((VisualizationServer<V, E>)this.primaryViewer);
    }

    public void fitGraphToViewerNow(VisualizationServer<V, E> theViewer) {
        this.scheduleViewChangeJob(new FitGraphToViewJob(theViewer));
    }

    public void fitGraphToViewerLater() {
        this.jobRunner.setFinalJob(new FitGraphToViewJob(new VisualizationServer[]{this.primaryViewer}));
    }

    public void fitGraphToViewerLater(VisualizationServer<V, E> theViewer) {
        this.jobRunner.setFinalJob(new FitGraphToViewJob(theViewer));
    }

    public void zoomInCompletely() {
        this.zoomInCompletely(null);
    }

    public void zoomInCompletely(V centerOnVertex) {
        this.setGraphScale(1.0);
        if (centerOnVertex == null) {
            return;
        }
        this.moveVertexToCenterWithoutAnimation(centerOnVertex);
    }

    public void moveVertexToCenterTopWithoutAnimation(V vertex) {
        this.stopAllAnimation();
        Point2D.Double desiredOffsetPoint = GraphViewerUtils.getVertexOffsetFromLayoutCenterTop(this.primaryViewer, vertex);
        double dx = desiredOffsetPoint.getX();
        double dy = desiredOffsetPoint.getY();
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(dx, dy);
        this.primaryViewer.repaint();
    }

    public void moveVertexToCenterWithoutAnimation(V vertex) {
        this.stopAllAnimation();
        Point2D.Double desiredOffsetPoint = GraphViewerUtils.getVertexOffsetFromLayoutCenter(this.primaryViewer, vertex);
        double dx = desiredOffsetPoint.getX();
        double dy = desiredOffsetPoint.getY();
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(dx, dy);
        this.primaryViewer.repaint();
    }

    public void moveVertexToCenterWithAnimation(V vertex) {
        this.moveVertexToCenterWithAnimation(vertex, null);
    }

    public void moveVertexToCenterWithAnimation(V vertex, BusyListener callbackListener) {
        MoveVertexToCenterAnimatorFunctionGraphJob<V, E> job = new MoveVertexToCenterAnimatorFunctionGraphJob<V, E>(this.primaryViewer, vertex, this.isAnimationEnabled());
        job.setBusyListener(callbackListener);
        this.scheduleViewChangeJob(job);
    }

    public void moveVertexToCenterTopWithAnimation(V vertex) {
        this.moveVertexToCenterTopWithAnimation(vertex, null);
    }

    public void moveVertexToCenterTopWithAnimation(V vertex, BusyListener callbackListener) {
        MoveVertexToCenterTopAnimatorFunctionGraphJob<V, E> job = new MoveVertexToCenterTopAnimatorFunctionGraphJob<V, E>(this.primaryViewer, vertex, this.isAnimationEnabled());
        job.setBusyListener(callbackListener);
        this.scheduleViewChangeJob(job);
    }

    public void moveViewerLocationWithoutAnimation(Point translation) {
        this.stopAllAnimation();
        double dx = translation.x;
        double dy = translation.y;
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(dx, dy);
        this.primaryViewer.repaint();
    }

    public void centerViewSpacePointWithAnimation(Point point) {
        this.scheduleViewChangeJob(new MoveViewToViewSpacePointAnimatorFunctionGraphJob<V, E>(this.primaryViewer, point, this.isAnimationEnabled()));
    }

    public void centerViewSpacePointWithoutAnimation(Point point) {
        Point pointInLayoutSpace = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(point, this.primaryViewer);
        this.centerLayoutSpacePointWithoutAnimation(pointInLayoutSpace);
    }

    public void centerLayoutSpacePointWithoutAnimation(Point point) {
        this.stopAllAnimation();
        Point2D.Double translationOffset = GraphViewerUtils.getOffsetFromCenterInLayoutSpace(this.primaryViewer, point);
        double dx = translationOffset.getX();
        double dy = translationOffset.getY();
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(dx, dy);
        this.primaryViewer.repaint();
    }

    public void setLayoutSpacePointWithoutAnimation(Point2D point) {
        this.stopAllAnimation();
        double dx = point.getX();
        double dy = point.getY();
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).translate(dx, dy);
        this.primaryViewer.repaint();
    }

    public void setLayoutSpacePointWithAnimation(Point point) {
        this.scheduleViewChangeJob(new MoveViewToLayoutSpacePointAnimatorFunctionGraphJob<V, E>(this.primaryViewer, point, this.isAnimationEnabled()));
    }

    public void ensureVertexVisible(V vertex, Rectangle area) {
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        Function transformer = renderContext.getVertexShapeTransformer();
        Shape shape = (Shape)transformer.apply(vertex);
        Rectangle bounds = shape.getBounds();
        this.ensureVertexAreaVisible(vertex, bounds, null);
    }

    public void ensureVertexAreaVisible(V vertex, Rectangle area, BusyListener callbackListener) {
        Objects.requireNonNull(vertex, "Vertex cannot be null");
        Objects.requireNonNull(area, "Area rectangle cannot be null");
        EnsureAreaVisibleAnimatorFunctionGraphJob<V, E> job = new EnsureAreaVisibleAnimatorFunctionGraphJob<V, E>(this.primaryViewer, this.satelliteViewer, vertex, area, this.isAnimationEnabled());
        job.setBusyListener(callbackListener);
        this.scheduleViewChangeJob(job);
    }

    public void updateEdgeShapes(Collection<E> edges) {
        if (!GraphViewerUtils.layoutUsesEdgeArticulations(this.primaryViewer.getGraphLayout())) {
            return;
        }
        BasicEdgeRouter<V, E> edgeRouter = new BasicEdgeRouter<V, E>(this.primaryViewer, edges);
        edgeRouter.route();
    }

    public void setGraphPerspective(GraphPerspectiveInfo<V, E> graphInfo) {
        if (graphInfo == null) {
            return;
        }
        this.stopAllAnimation();
        if (!graphInfo.isRestoreZoom()) {
            Msg.error((Object)this, (Object)"Restoring the view coordinates without restoring the zoom is currently not supported.", (Throwable)new AssertException());
        }
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        this.setGraphScale(graphInfo.getZoom());
        Point layoutPoint = graphInfo.getLayoutTranslateCoordinates();
        multiLayerTransformer.getTransformer(Layer.LAYOUT).setTranslate((double)layoutPoint.x, (double)layoutPoint.y);
        Point viewPoint = graphInfo.getViewTranslateCoordinates();
        multiLayerTransformer.getTransformer(Layer.VIEW).setTranslate((double)viewPoint.x, (double)viewPoint.y);
    }

    public void twinkeVertex(V vertex) {
        if (!GraphViewerUtils.isScaledPastVertexInteractionThreshold(this.primaryViewer)) {
            return;
        }
        if (vertexTwinkleAnimator != null) {
            if (vertexTwinkleAnimator.getVertex() == vertex) {
                return;
            }
            vertexTwinkleAnimator.stop();
        }
        vertexTwinkleAnimator = new TwinkleVertexAnimator<V, E>(this.primaryViewer, vertex, this.isAnimationEnabled());
        vertexTwinkleAnimator.start();
    }

    public void setGraphScale(double scale) {
        this.stopAllAnimation();
        GraphViewerUtils.setGraphScale(this.primaryViewer, scale);
    }

    public void animateEdgeHover() {
        if (edgeHoverAnimator != null) {
            edgeHoverAnimator.stop();
        }
        edgeHoverAnimator = new EdgeHoverAnimator<V, E>(this.primaryViewer, this.satelliteViewer, this.isAnimationEnabled());
        edgeHoverAnimator.start();
    }

    public boolean isBusy() {
        if (edgeHoverAnimator != null && !edgeHoverAnimator.hasFinished()) {
            return true;
        }
        if (vertexTwinkleAnimator != null && !vertexTwinkleAnimator.hasFinished()) {
            return true;
        }
        boolean busy = this.jobRunner.isBusy();
        return busy;
    }

    public boolean isMutatingGraph() {
        boolean busy = this.jobRunner.isBusy();
        return busy;
    }

    public void scheduleViewChangeJob(GraphJob job) {
        this.jobStartedListeners.forEach(l -> l.call());
        this.stopAllNonMutativeAnimation();
        this.jobRunner.schedule(job);
    }

    public void stopEdgeHoverAnimation() {
        if (edgeHoverAnimator != null) {
            edgeHoverAnimator.stop();
            edgeHoverAnimator = null;
        }
    }

    private void stopVertexTwinkleAnimation() {
        if (vertexTwinkleAnimator != null) {
            vertexTwinkleAnimator.stop();
            vertexTwinkleAnimator = null;
        }
    }

    public void stopAllAnimation() {
        this.stopAllNonMutativeAnimation();
        this.jobRunner.finishAllJobs();
    }

    protected void stopAllNonMutativeAnimation() {
        this.stopEdgeHoverAnimation();
        this.stopVertexTwinkleAnimation();
    }

    public void relayoutGraph() {
        this.scheduleViewChangeJob(new RelayoutFunctionGraphJob<V, E>(this.primaryViewer, this.isAnimationEnabled()));
    }
}

