/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.ObjectSelectedListener;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GFilterTable<ROW_OBJECT>
extends JPanel {
    private RowObjectTableModel<ROW_OBJECT> model;
    private GTable table;
    private GTableFilterPanel<ROW_OBJECT> filterPanel;
    private List<ObjectSelectedListener<ROW_OBJECT>> listeners = new ArrayList<ObjectSelectedListener<ROW_OBJECT>>();

    public GFilterTable(RowObjectTableModel<ROW_OBJECT> model) {
        super(new BorderLayout());
        this.model = model;
        this.buildTable();
    }

    public void dispose() {
        this.filterPanel.dispose();
    }

    public void setAccessibleNamePrefix(String prefix) {
        this.table.setAccessibleNamePrefix(prefix);
        this.filterPanel.setAccessibleNamePrefix(prefix);
    }

    private void buildTable() {
        if (this.model instanceof ThreadedTableModel) {
            this.buildThreadedTable();
        } else {
            this.buildNonThreadedTable();
        }
    }

    private void buildNonThreadedTable() {
        this.table = this.createTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        this.filterPanel = this.createTableFilterPanel(this.table, this.model);
        this.add(this.filterPanel, "South");
    }

    protected GTable createTable(RowObjectTableModel<ROW_OBJECT> tableModel) {
        GTable gTable = new GTable(tableModel);
        this.addTableSelectionListener(gTable);
        return gTable;
    }

    private void addTableSelectionListener(GTable gTable) {
        gTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.rowSelectionChanged();
            }
        });
    }

    private void buildThreadedTable() {
        GThreadedTablePanel<ROW_OBJECT> tablePanel = this.createThreadedTablePanel((ThreadedTableModel)this.model);
        this.table = tablePanel.getTable();
        this.addTableSelectionListener(this.table);
        this.add(tablePanel, "Center");
        this.filterPanel = this.createTableFilterPanel(this.table, this.model);
        this.add(this.filterPanel, "South");
    }

    protected GTableFilterPanel<ROW_OBJECT> createTableFilterPanel(GTable gTable, RowObjectTableModel<ROW_OBJECT> tableModel) {
        return new GTableFilterPanel<ROW_OBJECT>(gTable, tableModel);
    }

    protected GThreadedTablePanel<ROW_OBJECT> createThreadedTablePanel(ThreadedTableModel<ROW_OBJECT, ?> threadedModel) {
        return new GThreadedTablePanel<ROW_OBJECT>(threadedModel);
    }

    public GTable getTable() {
        return this.table;
    }

    public GTableFilterPanel<ROW_OBJECT> getFilterPanel() {
        return this.filterPanel;
    }

    public RowObjectTableModel<ROW_OBJECT> getModel() {
        return this.model;
    }

    public boolean isInView(ROW_OBJECT o) {
        return this.filterPanel.isInView(o);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.table.getSelectionManager().clearSavedSelection();
    }

    public List<ROW_OBJECT> getSelectedRowObjects() {
        List<ROW_OBJECT> items = this.filterPanel.getSelectedItems();
        return items;
    }

    public ROW_OBJECT getSelectedRowObject() {
        ROW_OBJECT item = this.filterPanel.getSelectedItem();
        return item;
    }

    public void setSelectedRowObject(ROW_OBJECT rowObject) {
        this.filterPanel.setSelectedItem(rowObject);
    }

    public ROW_OBJECT getRowObject(int viewRow) {
        ROW_OBJECT rowObject = this.filterPanel.getRowObject(viewRow);
        return rowObject;
    }

    public ROW_OBJECT getItemAt(Point point) {
        int viewRow = this.table.rowAtPoint(point);
        if (viewRow < 0) {
            return null;
        }
        ROW_OBJECT rowObject = this.filterPanel.getRowObject(viewRow);
        return rowObject;
    }

    public void setTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.filterPanel.setSecondaryFilter(tableFilter);
    }

    public void addSelectionListener(ObjectSelectedListener<ROW_OBJECT> l) {
        this.listeners.add(l);
    }

    public void removeSelectionListener(ObjectSelectedListener<ROW_OBJECT> l) {
        this.listeners.remove(l);
    }

    private void rowSelectionChanged() {
        ROW_OBJECT selectedObject = null;
        if (this.table.getSelectedRow() >= 0) {
            selectedObject = this.getSelectedRowObject();
        }
        if (selectedObject == null) {
            this.rowSelectionCleared();
            return;
        }
        this.rowSelected(selectedObject);
    }

    protected void rowSelectionCleared() {
        for (ObjectSelectedListener<ROW_OBJECT> l : this.listeners) {
            l.objectSelected(null);
        }
    }

    protected void rowSelected(ROW_OBJECT selectedObject) {
        for (ObjectSelectedListener<ROW_OBJECT> l : this.listeners) {
            l.objectSelected(selectedObject);
        }
    }

    public void focusFilter() {
        this.filterPanel.requestFocus();
    }

    public void setFiterText(String text) {
        this.filterPanel.setFilterText(text);
    }

    public int getRow(Point point) {
        return this.table.rowAtPoint(point);
    }

    public int getColumn(Point point) {
        return this.table.columnAtPoint(point);
    }

    public Object getCellValue(Point point) {
        int row = this.getRow(point);
        int col = this.getColumn(point);
        return this.table.getValueAt(row, col);
    }
}

