/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.TableFilterContext;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.EnumConstraintEditor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumColumnConstraint<T extends Enum<T>>
implements ColumnConstraint<T> {
    private Set<T> acceptableValues;
    private Class<T> enumClass;

    public EnumColumnConstraint(Class<T> enumClass, Set<T> acceptableValues) {
        this.enumClass = enumClass;
        this.acceptableValues = acceptableValues;
    }

    @Override
    public String getGroup() {
        return "enumeration";
    }

    @Override
    public String getName() {
        return "Is One Of";
    }

    @Override
    public boolean accepts(T value, TableFilterContext context) {
        return this.acceptableValues.contains(value);
    }

    @Override
    public ColumnConstraintEditor<T> getEditor(ColumnData<T> columnDataSource) {
        return new EnumConstraintEditor(this);
    }

    @Override
    public Class<T> getColumnType() {
        return this.enumClass;
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public Set<T> getSelectedValues() {
        return this.acceptableValues;
    }

    @Override
    public String getConstraintValueTooltip() {
        EnumConstraintEditor editor = (EnumConstraintEditor)this.getEditor(null);
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(this.acceptableValues.stream().map(editor::getElementDisplayName).collect(Collectors.joining(", ")));
        buf.append("}");
        return buf.toString();
    }

    @Override
    public String getConstraintValueString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(this.acceptableValues.stream().map(e -> e.toString()).collect(Collectors.joining(",")));
        buf.append("}");
        return buf.toString();
    }

    @Override
    public ColumnConstraint<T> parseConstraintValue(String newValue, Object dataSource) {
        HashSet<T> values = new HashSet<T>();
        if ((newValue = newValue.trim()).charAt(0) == '{' && newValue.charAt(newValue.length() - 1) == '}') {
            String[] split;
            String substring = newValue.substring(1, newValue.length() - 1);
            for (String string : split = substring.split("\\s*,\\s*")) {
                try {
                    T value = Enum.valueOf(this.enumClass, string.trim());
                    values.add(value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return new EnumColumnConstraint<T>(this.enumClass, values);
    }

    public int hashCode() {
        return Objects.hash(this.getEnumClass(), this.getSelectedValues());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumColumnConstraint other = (EnumColumnConstraint)obj;
        if (this.enumClass != other.enumClass) {
            return false;
        }
        return Objects.equals(this.acceptableValues, other.acceptableValues);
    }
}

