/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;

public class PowerPC_MachoRelocationHandler
extends MachoRelocationHandler {
    public boolean canRelocate(MachHeader header) {
        return header.getCpuType() == 18;
    }

    public boolean isPairedRelocation(RelocationInfo relocation) {
        return switch (relocation.getType()) {
            case 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15 -> true;
            default -> false;
        };
    }

    public RelocationResult relocate(MachoRelocation relocation) throws MemoryAccessException, RelocationException {
        if (!relocation.requiresRelocation()) {
            return RelocationResult.SKIPPED;
        }
        RelocationInfo relocationInfo = relocation.getRelocationInfo();
        switch (relocationInfo.getType()) {
            default: 
        }
        return RelocationResult.UNSUPPORTED;
    }
}

