/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;

class RustNamespace {
    String data;

    public RustNamespace(String data) {
        this.data = data;
    }

    public static RustNamespace parse(Symbol s) {
        char c = s.popChar();
        if (c == 'C') {
            return new RustNamespace("{closure}");
        }
        if (c == 'S') {
            return new RustNamespace("{shim}");
        }
        if (c >= 'A' && c <= 'Z') {
            return new RustNamespace(String.valueOf(c));
        }
        if (c >= 'a' && c <= 'z') {
            return new RustNamespace(String.valueOf(c));
        }
        return null;
    }

    public String toString() {
        return this.data;
    }
}

