/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import db.DBHandle;
import db.DBRecord;
import db.LongField;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class IDMapDB {
    private static final String TABLE_NAME = "IDMap";
    private static final Schema SCHEMA = new Schema(0, "ViewID", new Class[]{LongField.class}, new String[]{"OriginalID"});
    private static final int ORIGINAL_ID_COL = 0;
    private final ErrorHandler errorHandler;
    private final Table table;
    private Map<Long, Long> viewToOriginalMap;
    private Map<Long, Long> originalToViewMap;

    IDMapDB(DBHandle dbHandle, ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.table = IDMapDB.init(dbHandle, errorHandler);
        this.viewToOriginalMap = new HashMap<Long, Long>();
        this.originalToViewMap = new HashMap<Long, Long>();
    }

    private static Table init(DBHandle dbHandle, ErrorHandler errorHandler) {
        try {
            return dbHandle.createTable(TABLE_NAME, SCHEMA);
        }
        catch (IOException e) {
            errorHandler.dbError(e);
            return null;
        }
    }

    void invalidate() {
        this.viewToOriginalMap = null;
        this.originalToViewMap = null;
    }

    void clearAll() throws IOException {
        this.table.deleteAll();
        this.viewToOriginalMap = new HashMap<Long, Long>();
        this.originalToViewMap = new HashMap<Long, Long>();
    }

    private void reloadIfNeeded() {
        if (this.viewToOriginalMap != null) {
            return;
        }
        this.viewToOriginalMap = new HashMap<Long, Long>();
        this.originalToViewMap = new HashMap<Long, Long>();
        try {
            for (DBRecord rec : this.table) {
                long viewId = rec.getKey();
                long originalId = rec.getLongValue(0);
                this.viewToOriginalMap.put(viewId, originalId);
                this.originalToViewMap.put(originalId, viewId);
            }
        }
        catch (IOException e) {
            this.errorHandler.dbError(e);
        }
    }

    Long getOriginalIDFromViewID(long viewId) {
        this.reloadIfNeeded();
        return this.viewToOriginalMap.get(viewId);
    }

    Long getViewIDFromOriginalID(long originalId) {
        this.reloadIfNeeded();
        return this.originalToViewMap.get(originalId);
    }

    void put(long viewId, long originalId) {
        try {
            DBRecord rec = SCHEMA.createRecord(viewId);
            rec.setLongValue(0, originalId);
            this.table.putRecord(rec);
            if (this.viewToOriginalMap != null) {
                this.viewToOriginalMap.put(viewId, originalId);
                this.originalToViewMap.put(originalId, viewId);
            }
        }
        catch (IOException e) {
            this.errorHandler.dbError(e);
        }
    }

    Long remove(long viewId) {
        Long originalId = null;
        try {
            DBRecord rec = this.table.getRecord(viewId);
            if (rec != null) {
                originalId = rec.getLongValue(0);
                this.table.deleteRecord(viewId);
                if (this.viewToOriginalMap != null) {
                    this.viewToOriginalMap.remove(viewId);
                    this.originalToViewMap.remove(originalId);
                }
            }
        }
        catch (IOException e) {
            this.errorHandler.dbError(e);
        }
        return originalId;
    }
}

