/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.KeyBindingPrecedence;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeTransferHandler;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class CutAction
extends DockingAction {
    private Clipboard clipboard;
    private ClipboardOwner clipboardOwner;

    public CutAction(DataTypeManagerPlugin plugin) {
        super("Cut", plugin.getName());
        this.clipboard = plugin.getClipboard();
        this.setPopupMenuData(new MenuData(new String[]{"Cut"}, "Edit"));
        this.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(88, 128), KeyBindingPrecedence.ActionMapLevel));
        this.setEnabled(true);
        this.clipboardOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard currentClipboard, Transferable transferable) {
                GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
                List nodeList = gtTransferable.getAllData();
                CutAction.this.setNodesCut(nodeList, false);
            }
        };
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            DataTypeTreeNode node = (DataTypeTreeNode)((Object)path.getLastPathComponent());
            if (node.canCut()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        ArrayList<GTreeNode> nodeList = this.createList(gTree, paths);
        this.clearClipboard();
        this.setClipboardContents(gTree, this.clipboard, nodeList);
        this.setNodesCut(nodeList, true);
        gTree.repaint();
    }

    private void setNodesCut(List<GTreeNode> nodeList, boolean isCut) {
        for (GTreeNode node : nodeList) {
            DataTypeTreeNode cutNode = (DataTypeTreeNode)node;
            cutNode.setNodeCut(isCut);
        }
    }

    private ArrayList<GTreeNode> createList(GTree gTree, TreePath[] paths) {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (paths != null) {
            for (TreePath path : paths) {
                GTreeNode node = (GTreeNode)path.getLastPathComponent();
                GTreeNode modelNode = gTree.getModelNode(node);
                list.add(modelNode);
            }
        }
        return list;
    }

    private void clearClipboard() {
        Transferable transferable = this.clipboard.getContents((Object)this);
        if (transferable instanceof DataTypeTreeNodeTransferable) {
            GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
            List nodeList = gtTransferable.getAllData();
            this.setNodesCut(nodeList, false);
        }
    }

    private void setClipboardContents(GTree gTree, Clipboard clipboard, List<GTreeNode> list) {
        GTreeDragNDropHandler dragNDropHandler = gTree.getDragNDropHandler();
        DataTypeTreeNodeTransferable contents = new DataTypeTreeNodeTransferable(this, (GTreeTransferHandler)dragNDropHandler, list);
        clipboard.setContents((Transferable)((Object)contents), this.clipboardOwner);
    }

    class DataTypeTreeNodeTransferable
    extends GTreeNodeTransferable {
        public DataTypeTreeNodeTransferable(CutAction this$0, GTreeTransferHandler handler, List<GTreeNode> selectedData) {
            super(handler, selectedData);
        }
    }
}

