/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.MultiIcon;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class CommitSingleDataTypeAction
extends DockingAction {
    private static Icon COMMIT_ICON = new GIcon("icon.plugin.datatypes.commit.single.type");
    private final DataTypeManagerPlugin plugin;

    public CommitSingleDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Commit To Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Commit To Archive"}, "Sync"));
        this.setEnabled(true);
        MultiIcon multiIcon = new MultiIcon((Icon)new EmptyIcon(16, 16));
        multiIcon.addIcon((Icon)new TranslateIcon(COMMIT_ICON, 4, 5));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState syncStatus = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        switch (syncStatus) {
            case UNKNOWN: {
                return false;
            }
            case CONFLICT: 
            case COMMIT: 
            case ORPHAN: {
                return true;
            }
            case UPDATE: 
            case IN_SYNC: {
                return false;
            }
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        int result;
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dtm = dataType.getDataTypeManager();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState syncStatus = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        if (syncStatus == DataTypeSyncState.CONFLICT && (result = OptionDialog.showOptionDialog((Component)gTree, (String)"Lose Changes in Archive?", (String)"This data type has changes in the archive that will be\noverwritten if you commit this data type", (String)"Continue?", (int)2)) == 0) {
            return;
        }
        SourceArchive sourceArchive = dataType.getSourceArchive();
        DataTypeManager sourceDTM = this.plugin.getDataTypeManagerHandler().getDataTypeManager(sourceArchive);
        if (sourceDTM == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)"Commit Failed", (Object)("Source Archive not open: " + sourceArchive.getName()));
            return;
        }
        if (!sourceDTM.isUpdatable()) {
            DataTypeUtils.showUnmodifiableArchiveErrorMessage((Component)gTree, "Commit Failed!", sourceDTM);
            return;
        }
        if (!dataType.getDataTypeManager().isUpdatable()) {
            DataTypeUtils.showUnmodifiableArchiveErrorMessage((Component)gTree, "Commit Failed", dataType.getDataTypeManager());
            return;
        }
        this.plugin.commit(dataType);
        DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(handler, dtm, sourceArchive);
        synchronizer.reSyncOutOfSyncInTimeOnlyDataTypes();
    }
}

