/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingContextListener;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import java.util.function.Consumer;
import javax.swing.KeyStroke;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Component Provider Navigation", description="The plugin provides actions to manage switching between Component Providers.")
public class ProviderNavigationPlugin
extends Plugin {
    static final String GO_TO_LAST_ACTIVE_COMPONENT_ACTION_NAME = "Go To Last Active Component";
    private ComponentProvider previousActiveProvider;
    private ComponentProvider currentActiveProvider;
    private Consumer<ComponentProvider> providerActivator = provider -> this.tool.showComponentProvider(provider, true);
    private DockingContextListener contextListener = context -> {
        ComponentProvider componentProvider = context.getComponentProvider();
        if (componentProvider != null && componentProvider != this.currentActiveProvider) {
            this.previousActiveProvider = this.currentActiveProvider;
            this.currentActiveProvider = componentProvider;
        }
    };

    public ProviderNavigationPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        tool.addContextListener(this.contextListener);
    }

    private void createActions() {
        DockingAction previousProviderAction = new DockingAction(GO_TO_LAST_ACTIVE_COMPONENT_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext context) {
                ProviderNavigationPlugin.this.providerActivator.accept(ProviderNavigationPlugin.this.previousActiveProvider);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ProviderNavigationPlugin.this.previousActiveProvider != null;
            }
        };
        previousProviderAction.setMenuBarData(new MenuData(new String[]{"&Navigation", GO_TO_LAST_ACTIVE_COMPONENT_ACTION_NAME}, null, "GoToWindow", -1, "xLowInMenuSubGroup"));
        previousProviderAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(117, DockingUtils.CONTROL_KEY_MODIFIER_MASK)));
        previousProviderAction.setHelpLocation(new HelpLocation("Navigation", "Navigation_Previous_Provider"));
        this.tool.addAction((DockingActionIf)previousProviderAction);
    }

    void resetTrackingState() {
        this.previousActiveProvider = null;
        this.currentActiveProvider = null;
    }

    void setProviderActivator(Consumer<ComponentProvider> newActivator) {
        this.providerActivator = newActivator;
    }
}

