/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBlock;

public class DwarfDecodeContext {
    private final Program program;
    private final Address addr;
    private final MemoryBlock ehBlock;
    private final Address functionEntryPoint;
    private Object decodedValue;
    private int encodedLength;
    private MemBuffer buffer;

    public DwarfDecodeContext(Program program, Address readAddr) {
        this(program, readAddr, null, null);
    }

    public DwarfDecodeContext(Program program, Address readAddr, MemoryBlock ehBlock) {
        this(program, readAddr, ehBlock, null);
    }

    public DwarfDecodeContext(Program program, Address readAddr, Address entryPoint) {
        this(program, readAddr, null, entryPoint);
    }

    public DwarfDecodeContext(Program program, Address readAddr, Function function) {
        this(program, readAddr, null, function.getEntryPoint());
    }

    public DwarfDecodeContext(Program program, Address readAddr, MemoryBlock ehBlock, Address entryPoint) {
        if (program == null) {
            throw new NullPointerException("DwarfDecodeContext requires a program");
        }
        if (readAddr == null) {
            throw new NullPointerException("DwarfDecodeContext requires an address");
        }
        this.program = program;
        this.addr = readAddr;
        this.ehBlock = ehBlock;
        this.functionEntryPoint = entryPoint;
    }

    public DwarfDecodeContext(MemBuffer buffer, int length) {
        this(buffer, length, null, null);
    }

    public DwarfDecodeContext(MemBuffer buf, int length, MemoryBlock ehBlock, Address entryPoint) {
        this.buffer = buf;
        this.program = this.buffer.getMemory().getProgram();
        this.addr = this.buffer.getAddress();
        this.ehBlock = ehBlock;
        this.functionEntryPoint = entryPoint;
    }

    public Program getProgram() {
        return this.program;
    }

    public Address getAddress() {
        return this.addr;
    }

    public void setDecodedValue(Object value, int encodedLength) {
        this.decodedValue = value;
        this.encodedLength = encodedLength;
    }

    public Object getDecodedValue() {
        return this.decodedValue;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public MemoryBlock getEhBlock() {
        return this.ehBlock;
    }

    public Address getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }
}

