/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.ScriptInfo;
import ghidra.util.classfinder.ExtensionPoint;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public abstract class GhidraScriptProvider
implements ExtensionPoint,
Comparable<GhidraScriptProvider> {
    public String toString() {
        return this.getDescription();
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GhidraScriptProvider) {
            GhidraScriptProvider that = (GhidraScriptProvider)obj;
            return this.getDescription().equals(that.getDescription());
        }
        return false;
    }

    @Override
    public int compareTo(GhidraScriptProvider that) {
        return this.getDescription().compareToIgnoreCase(that.getDescription());
    }

    public boolean deleteScript(ResourceFile scriptSource) {
        return !scriptSource.exists() || scriptSource.delete();
    }

    public abstract String getDescription();

    public abstract String getExtension();

    public abstract GhidraScript getScriptInstance(ResourceFile var1, PrintWriter var2) throws GhidraScriptLoadException;

    public abstract void createNewScript(ResourceFile var1, String var2) throws IOException;

    public String getRuntimeEnvironmentName() {
        return null;
    }

    public Pattern getBlockCommentStart() {
        return null;
    }

    public Pattern getBlockCommentEnd() {
        return null;
    }

    public abstract String getCommentCharacter();

    protected void writeHeader(PrintWriter writer, String category) {
        if (category == null) {
            category = "_NEW_";
        }
        writer.println(this.getCommentCharacter() + "TODO write a description for this script");
        for (String metadataItem : ScriptInfo.METADATA) {
            writer.print(this.getCommentCharacter() + metadataItem + " ");
            if (metadataItem.equals("@category")) {
                writer.print(category);
            } else if (metadataItem.equals("@runtime")) {
                writer.print(this.getRuntimeEnvironmentName());
            }
            writer.println("");
        }
        writer.println("");
    }

    protected void writeBody(PrintWriter writer) {
        writer.println(this.getCommentCharacter() + "TODO Add User Code Here");
    }

    @Deprecated
    protected String fixupName(String scriptName) {
        return scriptName;
    }

    protected String getCertifyHeaderStart() {
        return null;
    }

    protected String getCertificationBodyPrefix() {
        return null;
    }

    protected String getCertifyHeaderEnd() {
        return null;
    }
}

