/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bean;

import docking.widgets.SmallBorderButton;
import generic.theme.GIcon;
import generic.theme.Gui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class FixedBitSizeValueField
extends JPanel {
    private static final Icon DROP_DOWN_MENU_ICON = new GIcon("icon.base.util.fixed.bit.size.field");
    protected JTextField valueField;
    protected JButton menuButton;
    private PlainDocument doc;
    private DocumentFilter docFilter;
    protected int radix = 16;
    protected boolean signed = false;
    private BigInteger maxUnsignedValue;
    private BigInteger maxSignedValue;
    private BigInteger minSignedValue;
    private BigInteger maxValue;
    private BigInteger minValue;
    protected JPopupMenu popupMenu;
    protected List<JCheckBoxMenuItem> menuItems = new ArrayList<JCheckBoxMenuItem>();
    protected List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public FixedBitSizeValueField(int bitSize, boolean includeFormatButton, boolean leftJustify) {
        this.setLayout(new BorderLayout());
        this.valueField = new JTextField();
        if (includeFormatButton) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            this.menuButton = new SmallBorderButton(" hex", DROP_DOWN_MENU_ICON);
            this.menuButton.setHorizontalTextPosition(10);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3));
            buttonPanel.add((Component)this.menuButton, "East");
            this.add((Component)buttonPanel, "East");
            this.menuButton.setFocusable(false);
            this.menuButton.addActionListener(e -> this.showPopup());
        }
        this.add((Component)this.valueField, "Center");
        Gui.registerFont((Component)this.valueField, (String)"font.monospaced");
        this.valueField.setMargin(new Insets(0, 2, 0, 2));
        this.createPopup();
        this.doc = new PlainDocument();
        this.docFilter = new MyDocFilter();
        this.doc.setDocumentFilter(this.docFilter);
        this.valueField.setDocument(this.doc);
        if (!leftJustify) {
            this.valueField.setHorizontalAlignment(11);
        }
        this.setBitSize(bitSize);
        this.setFormat(16, false);
    }

    public void setBitSize(int bitSize) {
        BigInteger b = BigInteger.valueOf(2L);
        this.maxSignedValue = b.pow(bitSize - 1).subtract(BigInteger.ONE);
        this.minSignedValue = b.pow(bitSize - 1).negate();
        this.maxUnsignedValue = b.pow(bitSize).subtract(BigInteger.ONE);
        this.maxValue = this.signed ? this.maxSignedValue : this.maxUnsignedValue;
        this.minValue = this.signed ? this.minSignedValue : BigInteger.ZERO;
        this.setValue(this.getValue());
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean processText() {
        String text = this.valueField.getText().trim();
        if (text.length() == 0) {
            return true;
        }
        if (this.signed && text.equals("-")) {
            return true;
        }
        BigInteger value = this.getValue(text);
        if (value == null) {
            return false;
        }
        if (value.compareTo(this.maxValue) > 0) {
            return false;
        }
        return value.compareTo(this.minValue) >= 0;
    }

    public void setMinMax(BigInteger min, BigInteger max) {
        this.minValue = min;
        this.maxValue = max;
    }

    protected void createPopup() {
        ActionListener actionListener = e -> {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            this.menuActivated(item);
        };
        this.popupMenu = new JPopupMenu();
        this.menuItems.add(new JCheckBoxMenuItem("Hex, Unsigned"));
        this.menuItems.add(new JCheckBoxMenuItem("Hex, Signed"));
        this.menuItems.add(new JCheckBoxMenuItem("Decimal, Unsigned"));
        this.menuItems.add(new JCheckBoxMenuItem("Decimal, Signed"));
        this.menuItems.add(new JCheckBoxMenuItem("Octal, Unsigned"));
        this.menuItems.add(new JCheckBoxMenuItem("Binary, Unsigned"));
        for (JCheckBoxMenuItem menuItem : this.menuItems) {
            this.popupMenu.add(menuItem);
            menuItem.addActionListener(actionListener);
        }
    }

    private void showPopup() {
        Dimension d = this.getSize();
        this.popupMenu.show(this, d.width, d.height);
    }

    protected void updatePopup() {
        for (JCheckBoxMenuItem menuItem : this.menuItems) {
            menuItem.setSelected(false);
        }
        int selectedMenuItem = -1;
        switch (this.radix) {
            case 2: {
                selectedMenuItem = this.signed ? -1 : 5;
                break;
            }
            case 8: {
                selectedMenuItem = this.signed ? -1 : 4;
                break;
            }
            case 10: {
                selectedMenuItem = this.signed ? 3 : 2;
                break;
            }
            case 16: {
                int n = selectedMenuItem = this.signed ? 1 : 0;
            }
        }
        if (selectedMenuItem != -1) {
            this.menuItems.get(selectedMenuItem).setSelected(true);
        }
    }

    protected void menuActivated(JCheckBoxMenuItem item) {
        int index = this.menuItems.indexOf(item);
        switch (index) {
            case 0: {
                this.setFormat(16, false);
                break;
            }
            case 1: {
                this.setFormat(16, true);
                break;
            }
            case 2: {
                this.setFormat(10, false);
                break;
            }
            case 3: {
                this.setFormat(10, true);
                break;
            }
            case 4: {
                this.setFormat(8, false);
                break;
            }
            case 5: {
                this.setFormat(2, false);
            }
        }
    }

    public void setFormat(int radix, boolean signed) {
        BigInteger curValue = this.getValue(this.valueField.getText());
        this.radix = radix;
        this.signed = signed;
        this.updatePopup();
        this.updateMenuButton();
        this.maxValue = signed ? this.maxSignedValue : this.maxUnsignedValue;
        BigInteger bigInteger = this.minValue = signed ? this.minSignedValue : BigInteger.ZERO;
        if (curValue != null) {
            BigInteger newValue = curValue;
            if (signed) {
                if (curValue.compareTo(this.maxValue) > 0) {
                    newValue = curValue.subtract(this.maxUnsignedValue.add(BigInteger.ONE));
                }
            } else if (curValue.compareTo(this.minValue) < 0) {
                newValue = curValue.add(this.maxUnsignedValue.add(BigInteger.ONE));
            }
            this.setValue(newValue);
        } else if (this.valueField.getText().trim().equals("-")) {
            this.setValue(null);
        }
    }

    protected void updateMenuButton() {
        if (this.menuButton == null) {
            return;
        }
        String buttonText = "";
        switch (this.radix) {
            case 16: {
                buttonText = " hex";
                break;
            }
            case 10: {
                buttonText = " dec";
                break;
            }
            case 8: {
                buttonText = " oct";
                break;
            }
            case 2: {
                buttonText = " bin";
            }
        }
        this.menuButton.setText(buttonText);
    }

    public boolean setValue(BigInteger value) {
        return this.setValue(value, false);
    }

    public boolean setValue(BigInteger value, boolean pad) {
        this.setText("");
        if (value == null) {
            return true;
        }
        if (value.compareTo(this.maxValue) > 0) {
            return false;
        }
        if (value.compareTo(this.minValue) < 0) {
            return false;
        }
        String valueString = value.toString(this.radix);
        if (pad) {
            valueString = this.pad(valueString);
        }
        this.setText(valueString);
        return true;
    }

    private String pad(String valueString) {
        if (this.signed) {
            return valueString;
        }
        String maxValueString = this.maxUnsignedValue.toString(this.radix);
        if (maxValueString.length() > valueString.length()) {
            StringBuffer buf = new StringBuffer();
            int n = maxValueString.length() - valueString.length();
            for (int i = 0; i < n; ++i) {
                buf.append("0");
            }
            buf.append(valueString);
            valueString = buf.toString();
        }
        return valueString;
    }

    private void setText(String text) {
        this.doc.setDocumentFilter(null);
        this.valueField.setText(text);
        this.doc.setDocumentFilter(this.docFilter);
    }

    BigInteger getValue(String text) {
        try {
            return new BigInteger(text, this.radix);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public BigInteger getValue() {
        return this.getValue(this.valueField.getText().trim());
    }

    String normalizeText(String s) {
        s = s.strip();
        if (this.radix == 16 && (s.startsWith("0x") || s.startsWith("0X"))) {
            return s.substring(2);
        }
        if (this.radix == 2 && (s.startsWith("0b") || s.startsWith("0B"))) {
            return s.substring(2);
        }
        return s;
    }

    public Component getTextComponent() {
        return this.valueField;
    }

    public void valueChanged() {
        if (this.listeners.size() == 0) {
            return;
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    class MyDocFilter
    extends DocumentFilter {
        MyDocFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            String oldText = FixedBitSizeValueField.this.doc.getText(0, FixedBitSizeValueField.this.doc.getLength());
            string = FixedBitSizeValueField.this.normalizeText(string);
            fb.insertString(offset, string, attr);
            if (!FixedBitSizeValueField.this.processText()) {
                fb.replace(0, FixedBitSizeValueField.this.doc.getLength(), oldText, attr);
                FixedBitSizeValueField.this.valueField.setCaretPosition(offset);
            }
            FixedBitSizeValueField.this.valueChanged();
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            String oldText = FixedBitSizeValueField.this.doc.getText(0, FixedBitSizeValueField.this.doc.getLength());
            fb.remove(offset, length);
            if (!FixedBitSizeValueField.this.processText()) {
                fb.replace(0, FixedBitSizeValueField.this.doc.getLength(), oldText, null);
                FixedBitSizeValueField.this.valueField.setCaretPosition(offset);
            }
            FixedBitSizeValueField.this.valueChanged();
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String oldText = FixedBitSizeValueField.this.doc.getText(0, FixedBitSizeValueField.this.doc.getLength());
            text = FixedBitSizeValueField.this.normalizeText(text);
            fb.replace(offset, length, text, attrs);
            if (!FixedBitSizeValueField.this.processText()) {
                fb.replace(0, FixedBitSizeValueField.this.doc.getLength(), oldText, attrs);
                FixedBitSizeValueField.this.valueField.setCaretPosition(offset);
            }
            FixedBitSizeValueField.this.valueChanged();
        }
    }
}

