/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamByteProvider
implements ByteProvider {
    private InputStream inputStream;
    private long length;
    private long currentIndex;

    public InputStreamByteProvider(InputStream inputStream, long length) {
        this.inputStream = inputStream;
        this.length = length;
    }

    @Override
    public void close() {
    }

    @Override
    public File getFile() {
        return null;
    }

    public InputStream getUnderlyingInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "InputStreamByteProvider Index=0x" + Long.toHexString(this.currentIndex) + " Length=0x" + Long.toHexString(this.length);
    }

    @Override
    public String getAbsolutePath() {
        return this.getName();
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public boolean isValidIndex(long index) {
        return index >= 0L && index < this.length;
    }

    @Override
    public byte readByte(long index) throws IOException {
        int value;
        if (index < this.currentIndex) {
            throw new IOException("Attempted to read byte that was already read.");
        }
        if (index > this.currentIndex) {
            this.currentIndex += this.inputStream.skip(index - this.currentIndex);
            if (this.currentIndex != index) {
                throw new IOException("Not enough bytes were skipped.");
            }
        }
        if ((value = this.inputStream.read()) == -1) {
            throw new EOFException();
        }
        ++this.currentIndex;
        return (byte)value;
    }

    @Override
    public byte[] readBytes(long index, long len) throws IOException {
        byte[] values;
        int nRead;
        if (index < this.currentIndex) {
            throw new IOException("Attempted to read bytes that were already read.");
        }
        if (index > this.currentIndex) {
            this.currentIndex += this.inputStream.skip(index - this.currentIndex);
            if (this.currentIndex != index) {
                throw new IOException("Not enough bytes were skipped.");
            }
        }
        if ((long)(nRead = this.inputStream.read(values = new byte[(int)len])) != len) {
            throw new EOFException();
        }
        this.currentIndex += len;
        return values;
    }
}

