/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AoutHeader
implements StructConverter {
    public static final int SIZEOF = 28;
    protected short magic;
    protected short vstamp;
    protected int tsize;
    protected int dsize;
    protected int bsize;
    protected int entry;
    protected int text_start;
    protected int data_start;

    AoutHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextShort();
        this.vstamp = reader.readNextShort();
        this.tsize = reader.readNextInt();
        this.dsize = reader.readNextInt();
        this.bsize = reader.readNextInt();
        this.entry = reader.readNextInt();
        this.text_start = reader.readNextInt();
        this.data_start = reader.readNextInt();
    }

    public short getMagic() {
        return this.magic;
    }

    public short getVersionStamp() {
        return this.vstamp;
    }

    public int getTextSize() {
        return this.tsize;
    }

    public int getInitializedDataSize() {
        return this.dsize;
    }

    public int getUninitializedDataSize() {
        return this.bsize;
    }

    public int getEntry() {
        return this.entry;
    }

    public int getTextStart() {
        return this.text_start;
    }

    public int getInitializedDataStart() {
        return this.data_start;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(AoutHeader.class);
    }
}

