/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFIndirectTableHeader;
import ghidra.app.util.bin.format.dwarf.DWARFLengthValue;
import java.io.IOException;

public class DWARFAddressListHeader
extends DWARFIndirectTableHeader {
    private final int addressSize;
    private final int segmentSelectorSize;
    private final int addrCount;

    public static DWARFAddressListHeader read(BinaryReader reader, int defaultIntSize) throws IOException {
        long startOffset = reader.getPointerIndex();
        DWARFLengthValue lengthInfo = DWARFLengthValue.read(reader, defaultIntSize);
        if (lengthInfo == null) {
            return null;
        }
        long endOffset = reader.getPointerIndex() + lengthInfo.length();
        short version = reader.readNextShort();
        if (version != 5) {
            throw new DWARFException("Unsupported DWARF version [%d]".formatted(version));
        }
        int addressSize = reader.readNextUnsignedByte();
        int segmentSelectorSize = reader.readNextUnsignedByte();
        long firstAddr = reader.getPointerIndex();
        reader.setPointerIndex(endOffset);
        int count = (int)((endOffset - firstAddr) / (long)(addressSize + segmentSelectorSize));
        return new DWARFAddressListHeader(startOffset, endOffset, firstAddr, addressSize, segmentSelectorSize, count);
    }

    public DWARFAddressListHeader(long startOffset, long endOffset, long firstElementOffset, int addressSize, int segmentSelectorSize, int addrCount) {
        super(startOffset, endOffset, firstElementOffset);
        this.addressSize = addressSize;
        this.segmentSelectorSize = segmentSelectorSize;
        this.addrCount = addrCount;
    }

    @Override
    public long getOffset(int index, BinaryReader reader) throws IOException {
        if (index < 0 || this.addrCount <= index) {
            throw new IOException("Invalid address index: %d".formatted(index));
        }
        long offset = this.firstElementOffset + (long)((this.addressSize + this.segmentSelectorSize) * index);
        long seg = this.segmentSelectorSize > 0 ? reader.readUnsignedValue(offset, this.segmentSelectorSize) : 0L;
        long addr = reader.readUnsignedValue(offset + (long)this.segmentSelectorSize, this.addressSize);
        return addr;
    }

    public int getAddressSize() {
        return this.addressSize;
    }

    public int getSegmentSelectorSize() {
        return this.segmentSelectorSize;
    }
}

