/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFIndirectTableHeader;
import ghidra.app.util.bin.format.dwarf.DWARFLengthValue;
import java.io.IOException;

public class DWARFStringOffsetTableHeader
extends DWARFIndirectTableHeader {
    private final int count;
    private final int intSize;

    public static DWARFStringOffsetTableHeader readV5(BinaryReader reader, int defaultIntSize) throws IOException {
        long startOffset = reader.getPointerIndex();
        DWARFLengthValue lengthInfo = DWARFLengthValue.read(reader, defaultIntSize);
        if (lengthInfo == null) {
            return null;
        }
        long endOffset = reader.getPointerIndex() + lengthInfo.length();
        short version = reader.readNextShort();
        if (version != 5) {
            throw new DWARFException("Unsupported DWARF version [%d]".formatted(version));
        }
        reader.readNextShort();
        long offsetArrayStart = reader.getPointerIndex();
        reader.setPointerIndex(endOffset);
        int count = (int)((endOffset - offsetArrayStart) / (long)lengthInfo.intSize());
        return new DWARFStringOffsetTableHeader(startOffset, endOffset, offsetArrayStart, lengthInfo.intSize(), count);
    }

    public DWARFStringOffsetTableHeader(long startOffset, long endOffset, long firstElementOffset, int intSize, int count) {
        super(startOffset, endOffset, firstElementOffset);
        this.intSize = intSize;
        this.count = count;
    }

    @Override
    public long getOffset(int index, BinaryReader reader) throws IOException {
        if (index < 0 || this.count <= index) {
            throw new IOException("Invalid indirect string index: %d [0x%x]".formatted(index, index));
        }
        return reader.readUnsignedValue(this.firstElementOffset + (long)(index * this.intSize), this.intSize);
    }
}

